/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpInvokeDynamic;
import software.coley.cafedude.classfile.instruction.BasicInstruction;
import software.coley.cafedude.classfile.instruction.CpRefInstruction;
import software.coley.cafedude.classfile.instruction.IincInstruction;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.classfile.instruction.IntOperandInstruction;
import software.coley.cafedude.classfile.instruction.LookupSwitchInstruction;
import software.coley.cafedude.classfile.instruction.MultiANewArrayInstruction;
import software.coley.cafedude.classfile.instruction.TableSwitchInstruction;
import software.coley.cafedude.classfile.instruction.WideInstruction;
import software.coley.cafedude.io.FallbackInstructionReader;
import software.coley.cafedude.io.IndexableByteStream;

public class InstructionReader {
    private final FallbackInstructionReader fallbackReader;

    public InstructionReader(@Nonnull FallbackInstructionReader fallbackReader) {
        this.fallbackReader = fallbackReader;
    }

    public InstructionReader() {
        this(FallbackInstructionReader.fail());
    }

    @Nonnull
    public List<Instruction> read(@Nonnull IndexableByteStream is, @Nonnull ConstPool pool, int codeLength) throws IOException {
        int start = is.getIndex();
        int end = start + codeLength;
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        FallbackInstructionReader fallbackReader = this.fallbackReader;
        block42: while (is.getIndex() < end) {
            int opcode = is.readUnsignedByte();
            switch (opcode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 16: {
                    instructions.add(new IntOperandInstruction(opcode, is.readByte()));
                    continue block42;
                }
                case 17: {
                    instructions.add(new IntOperandInstruction(opcode, is.readShort()));
                    continue block42;
                }
                case 18: {
                    instructions.add(InstructionReader.readLdc(is, pool));
                    continue block42;
                }
                case 19: 
                case 20: {
                    instructions.add(InstructionReader.readLdcW(is, pool, opcode));
                    continue block42;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    instructions.add(InstructionReader.readXLoad(is, opcode));
                    continue block42;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    instructions.add(new IntOperandInstruction(opcode, is.readUnsignedByte()));
                    continue block42;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 132: {
                    instructions.add(new IincInstruction(is.readUnsignedByte(), is.readByte()));
                    continue block42;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    instructions.add(new IntOperandInstruction(opcode, is.readShort()));
                    continue block42;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    instructions.add(new IntOperandInstruction(opcode, is.readShort()));
                    continue block42;
                }
                case 167: {
                    instructions.add(new IntOperandInstruction(167, is.readShort()));
                    continue block42;
                }
                case 168: {
                    instructions.add(new IntOperandInstruction(168, is.readShort()));
                    continue block42;
                }
                case 169: {
                    instructions.add(new IntOperandInstruction(169, is.readUnsignedByte()));
                    continue block42;
                }
                case 170: {
                    int pos = is.getIndex();
                    is.skip(4 - pos & 3);
                    int dflt = is.readInt();
                    int low = is.readInt();
                    int high = is.readInt();
                    int count = high - low + 1;
                    ArrayList<Integer> offsets = new ArrayList<Integer>(count);
                    for (int i = 0; i < count; ++i) {
                        offsets.add(is.readInt());
                    }
                    TableSwitchInstruction tswitch = new TableSwitchInstruction(dflt, low, high, offsets);
                    tswitch.notifyStartPosition(pos - 1);
                    instructions.add(tswitch);
                    continue block42;
                }
                case 171: {
                    LookupSwitchInstruction lswitch = InstructionReader.readLookupSwitchInstruction(is);
                    instructions.add(lswitch);
                    continue block42;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    instructions.add(InstructionReader.readMemberReferenceInstruction(is, pool, opcode));
                    continue block42;
                }
                case 185: {
                    ConstRef ref = (ConstRef)pool.get(is.readUnsignedShort());
                    is.readShort();
                    instructions.add(new CpRefInstruction(opcode, ref));
                    continue block42;
                }
                case 186: {
                    int index = is.readUnsignedShort();
                    is.readShort();
                    CpInvokeDynamic entry = (CpInvokeDynamic)pool.get(index);
                    instructions.add(new CpRefInstruction(186, entry));
                    continue block42;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    CpClass clazz = (CpClass)pool.get(is.readUnsignedShort());
                    instructions.add(new CpRefInstruction(opcode, clazz));
                    continue block42;
                }
                case 188: {
                    instructions.add(new IntOperandInstruction(188, is.readUnsignedByte()));
                    continue block42;
                }
                case 190: {
                    instructions.add(new BasicInstruction(190));
                    continue block42;
                }
                case 191: {
                    instructions.add(new BasicInstruction(191));
                    continue block42;
                }
                case 194: 
                case 195: {
                    instructions.add(new BasicInstruction(opcode));
                    continue block42;
                }
                case 196: {
                    int type = is.readUnsignedByte();
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: {
                            instructions.add(new WideInstruction(new IntOperandInstruction(type, is.readUnsignedShort())));
                            continue block42;
                        }
                        case 132: {
                            instructions.add(new WideInstruction(new IincInstruction(is.readUnsignedShort(), is.readShort())));
                            continue block42;
                        }
                    }
                    throw new IllegalStateException("Illegal wide instruction type: " + type);
                }
                case 197: {
                    int index = is.readUnsignedShort();
                    int dimensions = is.readUnsignedByte();
                    instructions.add(new MultiANewArrayInstruction((CpClass)pool.get(index), dimensions));
                    continue block42;
                }
                case 198: 
                case 199: {
                    instructions.add(new IntOperandInstruction(opcode, is.readShort()));
                    continue block42;
                }
                case 200: 
                case 201: {
                    instructions.add(new IntOperandInstruction(opcode, is.readInt()));
                    continue block42;
                }
            }
            instructions.addAll(fallbackReader.read(opcode, is));
        }
        return instructions;
    }

    @Nonnull
    public static IntOperandInstruction readXLoad(@Nonnull IndexableByteStream is, int opcode) throws IOException {
        return new IntOperandInstruction(opcode, is.readUnsignedByte());
    }

    @Nonnull
    public static CpRefInstruction readLdc(@Nonnull IndexableByteStream is, @Nonnull ConstPool pool) throws IOException {
        int index = is.readUnsignedByte();
        CpEntry entry = pool.get(index);
        return new CpRefInstruction(18, entry);
    }

    @Nonnull
    public static CpRefInstruction readLdcW(@Nonnull IndexableByteStream is, @Nonnull ConstPool pool, int opcode) throws IOException {
        int index = is.readUnsignedShort();
        CpEntry entry = pool.get(index);
        return new CpRefInstruction(opcode, entry);
    }

    @Nonnull
    public static LookupSwitchInstruction readLookupSwitchInstruction(@Nonnull IndexableByteStream is) throws IOException {
        int pos = is.getIndex();
        is.skip(4 - pos & 3);
        int dflt = is.readInt();
        int keyCount = is.readInt();
        ArrayList<Integer> keys = new ArrayList<Integer>(keyCount);
        ArrayList<Integer> offsets = new ArrayList<Integer>(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            keys.add(is.readInt());
            offsets.add(is.readInt());
        }
        LookupSwitchInstruction lswitch = new LookupSwitchInstruction(dflt, keys, offsets);
        lswitch.notifyStartPosition(pos - 1);
        return lswitch;
    }

    @Nonnull
    public static CpRefInstruction readMemberReferenceInstruction(@Nonnull IndexableByteStream is, @Nonnull ConstPool pool, int opcode) throws IOException {
        int index = is.readUnsignedShort();
        ConstRef ref = (ConstRef)pool.get(index);
        return new CpRefInstruction(opcode, ref);
    }
}

