/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.transform;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.instruction.BasicInstruction;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.classfile.instruction.IntOperandInstruction;
import software.coley.cafedude.io.FallbackInstructionReader;
import software.coley.cafedude.io.IndexableByteStream;
import software.coley.cafedude.io.InstructionReader;

public class IllegalRewritingInstructionsReader
implements FallbackInstructionReader {
    private static final Instruction NOP_INSN = new BasicInstruction(0);
    private static final Instruction ALOAD_0_INSN = new BasicInstruction(42);
    private static final Instruction CALOAD = new BasicInstruction(52);
    private static final Instruction RETURN_INSN = new BasicInstruction(177);
    private final int classVersion;
    private final ConstPool cp;
    boolean rewritten;

    public IllegalRewritingInstructionsReader(@Nonnull ConstPool cp, int classVersion) {
        this.cp = cp;
        this.classVersion = classVersion;
    }

    @Override
    @Nonnull
    public List<Instruction> read(int opcode, @Nonnull IndexableByteStream is) throws IOException {
        if (this.classVersion <= 52 && opcode == 233 || this.classVersion == 53 && opcode == 234 || this.classVersion >= 55 && opcode == 238) {
            this.rewritten = true;
            return Collections.singletonList(NOP_INSN);
        }
        switch (opcode) {
            case 202: {
                this.rewritten = true;
                is.readByte();
                return List.of(NOP_INSN, NOP_INSN);
            }
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 234: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readMemberReferenceInstruction(is, this.cp, 180));
            }
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 235: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readMemberReferenceInstruction(is, this.cp, 181));
            }
            case 220: 
            case 236: {
                this.rewritten = true;
                return Collections.singletonList(ALOAD_0_INSN);
            }
            case 224: 
            case 237: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readXLoad(is, 21));
            }
            case 230: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readLdc(is, this.cp));
            }
            case 231: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readLdcW(is, this.cp, 19));
            }
            case 232: {
                this.rewritten = true;
                return Collections.singletonList(RETURN_INSN);
            }
            case 227: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readMemberReferenceInstruction(is, this.cp, 182));
            }
            case 228: 
            case 229: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readLookupSwitchInstruction(is));
            }
            case 221: 
            case 222: 
            case 223: {
                this.rewritten = true;
                is.readUnsignedByte();
                return List.of(ALOAD_0_INSN, InstructionReader.readMemberReferenceInstruction(is, this.cp, 180));
            }
            case 225: {
                this.rewritten = true;
                IntOperandInstruction iload1 = InstructionReader.readXLoad(is, 21);
                is.readUnsignedByte();
                IntOperandInstruction iload2 = InstructionReader.readXLoad(is, 21);
                return List.of(iload1, iload2);
            }
            case 226: {
                this.rewritten = true;
                IntOperandInstruction iload = InstructionReader.readXLoad(is, 21);
                is.readUnsignedByte();
                return List.of(iload, CALOAD);
            }
            case 233: {
                this.rewritten = true;
                return Collections.singletonList(InstructionReader.readMemberReferenceInstruction(is, this.cp, 182));
            }
        }
        throw new IllegalStateException("Don't know how to rewrite " + opcode);
    }
}

