/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.util;

import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;

public class GrowingByteBuffer {
    private ByteBuffer buffer = ByteBuffer.allocate(1024);

    @Nonnull
    public GrowingByteBuffer ensureWriteable(int size) {
        int newLength;
        ByteBuffer buffer = this.buffer;
        int capacity = buffer.capacity();
        if (capacity < (newLength = buffer.position() + size)) {
            ByteBuffer copy = ByteBuffer.allocate(newLength + 16 >> 1 << 1);
            buffer.flip();
            copy.put(buffer);
            this.buffer = copy;
        }
        return this;
    }

    @Nonnull
    public GrowingByteBuffer putBoolean(boolean value) {
        this.ensureWriteable((int)1).buffer.put((byte)(value ? 1 : 0));
        return this;
    }

    @Nonnull
    public GrowingByteBuffer put(int value) {
        this.ensureWriteable((int)1).buffer.put((byte)value);
        return this;
    }

    @Nonnull
    public GrowingByteBuffer putShort(int value) {
        this.ensureWriteable((int)2).buffer.putShort((short)value);
        return this;
    }

    @Nonnull
    public GrowingByteBuffer putChar(char value) {
        this.ensureWriteable((int)2).buffer.putChar(value);
        return this;
    }

    @Nonnull
    public GrowingByteBuffer putInt(int value) {
        this.ensureWriteable((int)4).buffer.putInt(value);
        return this;
    }

    @Nonnull
    public GrowingByteBuffer putFloat(float value) {
        this.ensureWriteable((int)4).buffer.putFloat(value);
        return this;
    }

    @Nonnull
    public GrowingByteBuffer putLong(long value) {
        this.ensureWriteable((int)8).buffer.putLong(value);
        return this;
    }

    @Nonnull
    public GrowingByteBuffer putDouble(double value) {
        this.ensureWriteable((int)8).buffer.putDouble(value);
        return this;
    }

    public int position() {
        return this.buffer.position();
    }

    @Nonnull
    public GrowingByteBuffer skip(int bytes) {
        ByteBuffer buffer = this.ensureWriteable((int)bytes).buffer;
        buffer.position(buffer.position() + bytes);
        return this;
    }

    @Nonnull
    public ByteBuffer unwrap() {
        return this.buffer;
    }
}

