/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Lists {
    @Nonnull
    public static <T> List<T> add(@Nullable List<T> src, @Nullable T additional) {
        if (src == null) {
            if (additional == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(additional);
        }
        if (src.isEmpty()) {
            return Collections.singletonList(additional);
        }
        ArrayList<T> list = new ArrayList<T>(src);
        list.add(additional);
        return Lists.distinct(list);
    }

    @Nonnull
    public static <T> List<T> combine(@Nullable List<T> src1, @Nullable List<T> src2) {
        if (src1 == null) {
            src1 = Collections.emptyList();
        }
        if (src2 == null) {
            src2 = Collections.emptyList();
        }
        if (src2.isEmpty()) {
            if (src1.isEmpty()) {
                return Collections.emptyList();
            }
            return src1;
        }
        ArrayList<T> list = new ArrayList<T>(src1.size() + src2.size());
        list.addAll(src1);
        list.addAll(src2);
        return list;
    }

    @Nonnull
    public static <T> List<T> distinct(@Nullable List<T> src) {
        if (src == null || src.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> copy = new ArrayList<T>();
        for (T t : src) {
            if (copy.contains(t)) continue;
            copy.add(t);
        }
        return copy;
    }

    @Nonnull
    public static <T> List<T> disjoint(@Nullable List<T> src1, @Nullable List<T> src2) {
        ArrayList<T> results2;
        ArrayList<T> results1 = src1 == null ? Lists.noopList() : new ArrayList<T>(src1);
        ArrayList<T> arrayList = results2 = src2 == null ? Lists.noopList() : new ArrayList<T>(src2);
        if (src2 != null) {
            results1.removeAll(src2);
        }
        if (src1 != null) {
            results2.removeAll(src1);
        }
        return Lists.combine(results1, results2);
    }

    @Nonnull
    public static <T> List<T> union(@Nullable List<T> src1, @Nullable List<T> src2) {
        if (src1 == null || src2 == null || src1.isEmpty() || src2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> results = new ArrayList<T>(src1);
        results.retainAll(src2);
        return Lists.distinct(results);
    }

    @Nonnull
    public static <T> List<T> reversed(@Nonnull List<T> src) {
        if (src.isEmpty() || src.size() == 1) {
            return src;
        }
        ArrayList<T> copy = new ArrayList<T>(src.size());
        for (T t : src) {
            copy.add(0, t);
        }
        return copy;
    }

    @Nonnull
    public static <T> List<T> of(@Nullable T value) {
        return Collections.singletonList(value);
    }

    @Nonnull
    public static <T> List<T> of(@Nonnull T[] values) {
        int length = values.length;
        if (length == 0) {
            return Collections.emptyList();
        }
        if (length == 1) {
            return Collections.singletonList(values[0]);
        }
        ArrayList<T> list = new ArrayList<T>(length);
        list.addAll(Arrays.asList(values));
        return list;
    }

    @SafeVarargs
    public static <T> List<T> ofVar(T ... values) {
        return Lists.of(values);
    }

    public static <T extends Comparable<T>> int binarySearch(@Nonnull List<T> items, @Nonnull T target) {
        return Lists.binarySearch(items, target, 0, items.size() - 1);
    }

    public static <T extends Comparable<T>> int binarySearch(@Nonnull List<T> items, @Nonnull T target, int first, int last) {
        if (first > last) {
            return first == 0 && last == -1 ? last : -last;
        }
        int middle = (first + last) / 2;
        int compResult = target.compareTo((Comparable)((Comparable)items.get(middle)));
        if (compResult == 0) {
            return middle;
        }
        if (compResult < 0) {
            return Lists.binarySearch(items, target, first, middle - 1);
        }
        return Lists.binarySearch(items, target, middle + 1, last);
    }

    public static <T extends Comparable<T>> int sortedInsertIndex(@Nonnull List<T> list, @Nonnull T item) {
        return Lists.sortedInsertIndex(null, list, item);
    }

    public static <T> int sortedInsertIndex(@Nullable Comparator<T> comparator, @Nonnull List<T> list, @Nonnull T item) {
        if (list.isEmpty()) {
            return 0;
        }
        int i = Collections.binarySearch(list, item, comparator);
        if (i < 0) {
            i = -i - 1;
        }
        return i;
    }

    public static <T extends Comparable<T>> int compare(@Nonnull List<T> listA, @Nonnull List<T> listB) {
        int len = Math.min(listA.size(), listB.size());
        for (int i = 0; i < len; ++i) {
            int cmp = ((Comparable)listA.get(i)).compareTo((Comparable)listB.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public static <T> int compare(@Nonnull Comparator<T> comparator, @Nonnull List<T> listA, @Nonnull List<T> listB) {
        int len = Math.min(listA.size(), listB.size());
        for (int i = 0; i < len; ++i) {
            int cmp = comparator.compare(listA.get(i), listB.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Nonnull
    public static <T> List<T> noopList() {
        return new AbstractList<T>(){

            @Override
            public boolean add(T t) {
                return false;
            }

            @Override
            public T set(int index, T element) {
                return null;
            }

            @Override
            public void add(int index, T element) {
            }

            @Override
            public T remove(int index) {
                return null;
            }

            @Override
            public T get(int index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }
}

