/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Maps {
    @Nonnull
    public static <K, V, M extends Map<K, V>> M add(@Nonnull Supplier<M> resultMapSupplier, @Nullable Map<K, V> map, K key, V value) {
        Map result = (Map)resultMapSupplier.get();
        if (map != null) {
            result.putAll(map);
        }
        result.put(key, value);
        return (M)result;
    }

    @Nonnull
    public static <K, V> Map<K, V> add(@Nullable Map<K, V> map, K key, V value) {
        if (map == null) {
            return Collections.singletonMap(key, value);
        }
        HashMap<K, V> result = new HashMap<K, V>(map);
        result.put(key, value);
        return result;
    }

    @Nonnull
    public static <K, V, M extends Map<K, V>> M combine(@Nonnull Supplier<M> resultMapSupplier, @Nullable Map<K, V> src1, @Nullable Map<K, V> src2) {
        Map result = (Map)resultMapSupplier.get();
        if (src1 != null) {
            result.putAll(src1);
        }
        if (src2 != null) {
            result.putAll(src2);
        }
        return (M)result;
    }

    @Nonnull
    public static <K, V> Map<K, V> combine(@Nullable Map<K, V> src1, @Nullable Map<K, V> src2) {
        if (src1 == null) {
            if (src2 == null) {
                return Collections.emptyMap();
            }
            return src2;
        }
        HashMap<K, V> map = new HashMap<K, V>(src1);
        if (src2 != null) {
            map.putAll(src2);
        }
        return map;
    }

    @Nonnull
    public static <K, V, M extends Map<K, V>> M distinct(@Nonnull Supplier<M> resultMapSupplier, @Nullable Map<K, V> src1, @Nullable Map<K, V> src2) {
        Map map1 = (Map)resultMapSupplier.get();
        if (src1 != null) {
            map1.putAll(src1);
        }
        if (src2 != null) {
            for (K key : src2.keySet()) {
                map1.remove(key);
            }
        }
        Map map2 = (Map)resultMapSupplier.get();
        if (src2 != null) {
            map2.putAll(src2);
        }
        if (src1 != null) {
            for (K key : src1.keySet()) {
                map2.remove(key);
            }
        }
        return Maps.combine(resultMapSupplier, map1, map2);
    }

    @Nonnull
    public static <K, V> Map<K, V> distinct(@Nullable Map<K, V> src1, @Nullable Map<K, V> src2) {
        HashMap<K, V> map2;
        HashMap<K, V> map1;
        if (src1 != null) {
            map1 = new HashMap<K, V>(src1);
            if (src2 != null) {
                for (K key : src2.keySet()) {
                    map1.remove(key);
                }
            }
        } else {
            map1 = null;
        }
        if (src2 != null) {
            map2 = new HashMap<K, V>(src2);
            if (src1 != null) {
                for (K key : src1.keySet()) {
                    map2.remove(key);
                }
            }
        } else {
            map2 = null;
        }
        return Maps.combine(map1, map2);
    }

    @Nonnull
    public static <K, V, M extends Map<K, V>> M union(@Nonnull Supplier<M> resultMapSupplier, @Nullable Map<K, V> src1, @Nullable Map<K, V> src2) {
        Map result = (Map)resultMapSupplier.get();
        if (src1 != null) {
            result.putAll(src1);
        }
        if (src2 != null) {
            for (Object key : result.keySet()) {
                if (src2.containsKey(key)) continue;
                result.remove(key);
            }
        }
        return (M)result;
    }

    @Nonnull
    public static <K, V> Map<K, V> union(@Nullable Map<K, V> src1, @Nullable Map<K, V> src2) {
        if (src1 == null || src1.isEmpty() || src2 == null || src2.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(src1);
        for (Object key : result.keySet()) {
            if (src2.containsKey(key)) continue;
            result.remove(key);
        }
        return result;
    }

    @Nonnull
    public static <K, V> Map<K, V> of(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    @Nonnull
    public static <K, V> Map<V, K> reverse(@Nullable Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        map.forEach((k, v) -> result.put(v, k));
        return result;
    }
}

