/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.collections.func.TriConsumer;
import software.coley.collections.func.UncheckedBiConsumer;
import software.coley.collections.func.UncheckedBiFunction;
import software.coley.collections.func.UncheckedConsumer;
import software.coley.collections.func.UncheckedFunction;
import software.coley.collections.func.UncheckedRunnable;
import software.coley.collections.func.UncheckedSupplier;

public class Unchecked {
    public static <T> T cast(@Nullable Object value) {
        return (T)value;
    }

    public static void run(@Nonnull UncheckedRunnable runnable) {
        runnable.run();
    }

    public static <T> T get(@Nonnull UncheckedSupplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T getOr(@Nullable UncheckedSupplier<T> supplier, T fallback) {
        if (supplier == null) {
            return fallback;
        }
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return fallback;
        }
    }

    public static <T> void accept(@Nonnull UncheckedConsumer<T> consumer, T value) {
        consumer.accept(value);
    }

    public static <T, U> void baccept(@Nonnull UncheckedBiConsumer<T, U> consumer, T t, U u) {
        consumer.accept(t, u);
    }

    public static <T, R> R map(@Nonnull UncheckedFunction<T, R> fn, T value) {
        return fn.apply(value);
    }

    public static <T, U, R> R bmap(@Nonnull UncheckedBiFunction<T, U, R> fn, T t, U u) {
        return fn.apply(t, u);
    }

    @Nonnull
    public static Runnable runnable(@Nonnull UncheckedRunnable runnable) {
        return runnable;
    }

    @Nonnull
    public static <T> Supplier<T> supply(@Nonnull UncheckedSupplier<T> supplier) {
        return supplier;
    }

    @Nonnull
    public static <T> Consumer<T> consumer(@Nonnull UncheckedConsumer<T> consumer) {
        return consumer;
    }

    @Nonnull
    public static <T, U> BiConsumer<T, U> bconsumer(@Nonnull UncheckedBiConsumer<T, U> consumer) {
        return consumer;
    }

    @Nonnull
    public static <T, R> Function<T, R> function(@Nonnull UncheckedFunction<T, R> fn) {
        return fn;
    }

    @Nonnull
    public static <T, U, R> BiFunction<T, U, R> bfunction(@Nonnull UncheckedBiFunction<T, U, R> fn) {
        return fn;
    }

    public static <X extends Throwable> void propagate(@Nonnull Throwable t) throws X {
        throw t;
    }

    public static <T> void checkedForEach(@Nonnull Collection<T> collection, @Nonnull UncheckedConsumer<T> consumer, @Nonnull BiConsumer<T, Throwable> errorConsumer) {
        for (T item : new ArrayList<T>(collection)) {
            try {
                consumer.accept(item);
            }
            catch (Throwable t) {
                errorConsumer.accept(item, t);
            }
        }
    }

    public static <K, V> void checkedForEach(@Nonnull Map<K, V> map, @Nonnull BiConsumer<K, V> consumer, @Nonnull TriConsumer<K, V, Throwable> errorConsumer) {
        for (Map.Entry<K, V> entry : new ArrayList<Map.Entry<K, V>>(map.entrySet())) {
            K key = entry.getKey();
            V value = entry.getValue();
            try {
                consumer.accept(key, value);
            }
            catch (Throwable t) {
                errorConsumer.accept(key, value, t);
            }
        }
    }
}

