/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.bidi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.collections.bidi.BiMap;
import software.coley.collections.delegate.DelegatingMap;

public abstract class AbstractBiMap<K, V>
extends DelegatingMap<K, V>
implements BiMap<K, V> {
    public AbstractBiMap(@Nonnull Map<K, V> delegate) {
        super(delegate);
        this.validate(delegate);
    }

    protected void validate(@Nonnull Map<K, V> map) {
        HashSet<V> values = new HashSet<V>();
        for (V value : map.values()) {
            if (values.contains(value)) {
                throw new IllegalArgumentException("Delegate map has duplicate value: " + value);
            }
            values.add(value);
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.values().contains(value)) {
            throw new IllegalArgumentException("BiMap already has value: " + value);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        Collection values = this.values();
        for (V value : m.values()) {
            if (!values.contains(value)) continue;
            throw new IllegalArgumentException("BiMap already has value: " + value);
        }
        super.putAll(m);
    }

    @Override
    @Nonnull
    public Set<V> values() {
        return new HashSet(super.values());
    }

    @Override
    @Nonnull
    public BiMap<V, K> reversed() {
        AbstractBiMap map = this.createImpl();
        this.forEach((key, value) -> map.put(value, key));
        return map;
    }

    @Nonnull
    protected abstract <K1, V1> AbstractBiMap<K1, V1> createImpl();
}

