/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.box;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import software.coley.collections.func.ObjToIntFunction;
import software.coley.collections.func.ObjToLongFunction;

public class Box<T> {
    private T value;

    public Box() {
        this(null);
    }

    public Box(@Nullable T value) {
        this.set(value);
    }

    @Nullable
    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public <R> R map(Function<T, R> function) {
        return this.isSet() ? (R)function.apply(this.get()) : null;
    }

    public int mapToInt(ObjToIntFunction<T> function) {
        return this.isSet() ? -1 : function.map(this.get());
    }

    public int mapNullableToInt(ObjToIntFunction<T> function) {
        return function.map(this.get());
    }

    public long mapToLong(ObjToLongFunction<T> function) {
        return this.isSet() ? -1L : function.map(this.get());
    }

    public long mapNullableToLong(ObjToLongFunction<T> function) {
        return function.map(this.get());
    }

    public <R> R mapNullable(Function<T, R> function) {
        return function.apply(this.get());
    }

    public T getAndSet(T newValue) {
        T oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    public T getAndCompute(Function<T, T> newValue) {
        T oldValue = this.get();
        this.set(newValue.apply(oldValue));
        return oldValue;
    }

    public T computeIfAbsent(Supplier<T> supplier) {
        if (!this.isSet()) {
            this.set(supplier.get());
        }
        return this.value;
    }

    public void setMin(T value, Comparator<T> comparator) {
        if (!this.isSet() || comparator.compare(value, this.get()) < 0) {
            this.set(value);
        }
    }

    public void setMax(T value, Comparator<T> comparator) {
        if (!this.isSet() || comparator.compare(value, this.get()) > 0) {
            this.set(value);
        }
    }

    public void clear() {
        this.set(null);
    }

    public boolean test(Predicate<T> predicate) {
        return this.isSet() && predicate.test(this.get());
    }

    public boolean isSet() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Box box = (Box)o;
        return Objects.equals(this.value, box.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

