/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.box;

import software.coley.collections.func.CharFunction;
import software.coley.collections.func.CharPredicate;

public class CharBox {
    private char value;

    public CharBox() {
    }

    public CharBox(char value) {
        this.set(value);
    }

    public char get() {
        return this.value;
    }

    public void set(char value) {
        this.value = value;
    }

    public <R> R map(CharFunction<R> function) {
        return function.apply(this.get());
    }

    public boolean test(CharPredicate predicate) {
        return predicate.test(this.get());
    }

    public char min(char other) {
        char c = this.get();
        return c < other ? c : other;
    }

    public char max(char other) {
        char c = this.get();
        return c > other ? c : other;
    }

    public char clamp(char min, char max) {
        char c = this.get();
        return c < min ? min : (c > max ? max : c);
    }

    public void setMin(char min) {
        if (this.get() < min) {
            this.set(min);
        }
    }

    public void setMax(char max) {
        if (this.get() > max) {
            this.set(max);
        }
    }

    public void setClamp(char min, char max) {
        char oldValue = this.get();
        if (oldValue < min) {
            this.set(min);
        } else if (oldValue > max) {
            this.set(max);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharBox box = (CharBox)o;
        return this.value == box.value;
    }

    public int hashCode() {
        return this.value;
    }
}

