/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.box;

import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;

public class DoubleBox {
    private double value;

    public DoubleBox() {
    }

    public DoubleBox(double value) {
        this.set(value);
    }

    public double get() {
        return this.value;
    }

    public void set(double value) {
        this.value = value;
    }

    public <R> R map(DoubleFunction<R> function) {
        return function.apply(this.get());
    }

    public boolean test(DoublePredicate predicate) {
        return predicate.test(this.get());
    }

    public double min(double other) {
        return Math.min(this.get(), other);
    }

    public double max(double other) {
        return Math.max(this.get(), other);
    }

    public double clamp(double min, double max) {
        return this.get() > max ? max : Math.max(this.get(), min);
    }

    public void setMin(double min) {
        if (this.get() < min) {
            this.set(min);
        }
    }

    public void setMax(double max) {
        if (this.get() > max) {
            this.set(max);
        }
    }

    public void setClamp(double min, double max) {
        double oldValue = this.get();
        if (oldValue < min) {
            this.set(min);
        } else if (oldValue > max) {
            this.set(max);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleBox box = (DoubleBox)o;
        return this.value == box.value;
    }

    public int hashCode() {
        long bits = Double.doubleToRawLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }
}

