/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.box;

import software.coley.collections.func.FloatFunction;
import software.coley.collections.func.FloatPredicate;

public class FloatBox {
    private float value;

    public FloatBox() {
    }

    public FloatBox(float value) {
        this.set(value);
    }

    public float get() {
        return this.value;
    }

    public void set(float value) {
        this.value = value;
    }

    public <R> R map(FloatFunction<R> function) {
        return function.apply(this.get());
    }

    public boolean test(FloatPredicate predicate) {
        return predicate.test(this.get());
    }

    public float min(float other) {
        return Math.min(this.get(), other);
    }

    public float max(float other) {
        return Math.max(this.get(), other);
    }

    public float clamp(float min, float max) {
        return this.get() > max ? max : Math.max(this.get(), min);
    }

    public void setMin(float min) {
        if (this.get() < min) {
            this.set(min);
        }
    }

    public void setMax(float max) {
        if (this.get() > max) {
            this.set(max);
        }
    }

    public void setClamp(float min, float max) {
        float oldValue = this.get();
        if (oldValue < min) {
            this.set(min);
        } else if (oldValue > max) {
            this.set(max);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatBox box = (FloatBox)o;
        return this.value == box.value;
    }

    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }
}

