/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.box;

import java.util.function.IntFunction;
import java.util.function.IntPredicate;

public class IntBox {
    private int value;

    public IntBox() {
    }

    public IntBox(int value) {
        this.set(value);
    }

    public int get() {
        return this.value;
    }

    public void set(int value) {
        this.value = value;
    }

    public <R> R map(IntFunction<R> function) {
        return function.apply(this.get());
    }

    public boolean test(IntPredicate predicate) {
        return predicate.test(this.get());
    }

    public int min(int other) {
        return Math.min(this.get(), other);
    }

    public int max(int other) {
        return Math.max(this.get(), other);
    }

    public int clamp(int min, int max) {
        return this.get() > max ? max : Math.max(this.get(), min);
    }

    public void setMin(int min) {
        if (this.get() < min) {
            this.set(min);
        }
    }

    public void setMax(int max) {
        if (this.get() > max) {
            this.set(max);
        }
    }

    public void setClamp(int min, int max) {
        int oldValue = this.get();
        if (oldValue < min) {
            this.set(min);
        } else if (oldValue > max) {
            this.set(max);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBox box = (IntBox)o;
        return this.value == box.value;
    }

    public int hashCode() {
        return this.value;
    }
}

