/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.box;

import java.util.function.LongFunction;
import java.util.function.LongPredicate;

public class LongBox {
    private long value;

    public LongBox() {
    }

    public LongBox(long value) {
        this.set(value);
    }

    public long get() {
        return this.value;
    }

    public void set(long value) {
        this.value = value;
    }

    public <R> R map(LongFunction<R> function) {
        return function.apply(this.get());
    }

    public boolean test(LongPredicate predicate) {
        return predicate.test(this.get());
    }

    public long min(long other) {
        return Math.min(this.get(), other);
    }

    public long max(long other) {
        return Math.max(this.get(), other);
    }

    public long clamp(long min, long max) {
        return this.get() > max ? max : Math.max(this.get(), min);
    }

    public void setMin(long min) {
        if (this.get() < min) {
            this.set(min);
        }
    }

    public void setMax(long max) {
        if (this.get() > max) {
            this.set(max);
        }
    }

    public void setClamp(long min, long max) {
        long oldValue = this.get();
        if (oldValue < min) {
            this.set(min);
        } else if (oldValue > max) {
            this.set(max);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongBox box = (LongBox)o;
        return this.value == box.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

