/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.delegate;

import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.collections.delegate.DelegatingQueue;

public class DelegatingDeque<T>
extends DelegatingQueue<T>
implements Deque<T> {
    private final Deque<T> delegate;

    public DelegatingDeque(@Nonnull Deque<T> delegate) {
        super(delegate);
        this.delegate = Objects.requireNonNull(delegate, "Cannot delegate to a null deque");
    }

    @Override
    public void addFirst(T t) {
        this.delegate.addFirst(t);
    }

    @Override
    public void addLast(T t) {
        this.delegate.addLast(t);
    }

    @Override
    public boolean offerFirst(T t) {
        return this.delegate.offerFirst(t);
    }

    @Override
    public boolean offerLast(T t) {
        return this.delegate.offerLast(t);
    }

    @Override
    public T removeFirst() {
        return this.delegate.removeFirst();
    }

    @Override
    public T removeLast() {
        return this.delegate.removeLast();
    }

    @Override
    public T pollFirst() {
        return this.delegate.pollFirst();
    }

    @Override
    public T pollLast() {
        return this.delegate.pollLast();
    }

    @Override
    public T getFirst() {
        return this.delegate.getFirst();
    }

    @Override
    public T getLast() {
        return this.delegate.getLast();
    }

    @Override
    public T peekFirst() {
        return this.delegate.peekFirst();
    }

    @Override
    public T peekLast() {
        return this.delegate.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.delegate.removeFirstOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.delegate.removeLastOccurrence(o);
    }

    @Override
    public void push(T t) {
        this.delegate.push(t);
    }

    @Override
    public T pop() {
        return this.delegate.pop();
    }

    @Override
    @Nonnull
    public Iterator<T> descendingIterator() {
        return this.delegate.descendingIterator();
    }
}

