/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.delegate;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.collections.delegate.DelegatingCollection;

public class DelegatingList<T>
extends DelegatingCollection<T>
implements List<T> {
    private final List<T> delegate;

    public DelegatingList(@Nonnull List<T> delegate) {
        super(delegate);
        this.delegate = Objects.requireNonNull(delegate, "Cannot delegate to a null list");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.delegate.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }
}

