/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.delegate;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class DelegatingMap<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate;

    public DelegatingMap(@Nonnull Map<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Cannot delegate to a null map");
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

