/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.delegate;

import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nonnull;
import software.coley.collections.delegate.DelegatingCollection;

public class DelegatingQueue<T>
extends DelegatingCollection<T>
implements Queue<T> {
    private final Queue<T> delegate;

    public DelegatingQueue(@Nonnull Queue<T> delegate) {
        super(delegate);
        this.delegate = Objects.requireNonNull(delegate, "Cannot delegate to a null queue");
    }

    @Override
    public boolean offer(T t) {
        return this.delegate.offer(t);
    }

    @Override
    public T remove() {
        return this.delegate.remove();
    }

    @Override
    public T poll() {
        return this.delegate.poll();
    }

    @Override
    public T element() {
        return this.delegate.element();
    }

    @Override
    public T peek() {
        return this.delegate.peek();
    }
}

