/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.observable;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.collections.Lists;
import software.coley.collections.observable.Change;

public class ListChange<T>
extends Change<T, List<T>> {
    private final int start;
    private final int end;

    public ListChange(@Nonnull List<T> added, @Nonnull List<T> removed, int start, int end) {
        super(added, removed);
        this.start = start;
        this.end = end;
    }

    @Nonnull
    public static <T> ListChange<T> addition(@Nullable T added, int from) {
        return ListChange.addition(Lists.of(added), from);
    }

    @Nonnull
    public static <T> ListChange<T> addition(@Nonnull List<T> added, int from) {
        return new ListChange<T>(added, Collections.emptyList(), from, from + added.size());
    }

    @Nonnull
    public static <T> ListChange<T> removal(@Nullable T removed, int from) {
        return ListChange.removal(Lists.of(removed), from);
    }

    @Nonnull
    public static <T> ListChange<T> removal(@Nonnull List<T> removed, int from) {
        return new ListChange(Collections.emptyList(), removed, from, from + removed.size());
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

