/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.observable;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import software.coley.collections.observable.SetChange;

public class MapChange<K, V>
extends SetChange<V> {
    private final Set<Entry<K, V>> addedEntries;
    private final Set<Entry<K, V>> removedEntries;

    public MapChange(@Nonnull Set<Entry<K, V>> addedEntries, @Nonnull Set<Entry<K, V>> removedEntries) {
        super(MapChange.extractValues(addedEntries), MapChange.extractValues(removedEntries));
        this.addedEntries = addedEntries;
        this.removedEntries = removedEntries;
    }

    @Nonnull
    private static <K, V> Set<V> extractValues(@Nonnull Set<Entry<K, V>> entries) {
        return entries.stream().map(Entry::getValue).collect(Collectors.toSet());
    }

    @Nonnull
    public static <K, V> MapChange<K, V> addition(@Nonnull Map<K, V> added) {
        Set<Entry<K, V>> mappedAdded = added.entrySet().stream().map(Entry::new).collect(Collectors.toSet());
        return new MapChange<K, V>(mappedAdded, Collections.emptySet());
    }

    @Nonnull
    public static <K, V> MapChange<K, V> removal(@Nonnull Map<K, V> removed) {
        Set<Entry<K, V>> mappedRemoved = removed.entrySet().stream().map(Entry::new).collect(Collectors.toSet());
        return new MapChange<K, V>(Collections.emptySet(), mappedRemoved);
    }

    @Nonnull
    public Set<Entry<K, V>> getAddedEntries() {
        return this.addedEntries;
    }

    @Nonnull
    public Set<Entry<K, V>> getRemovedEntries() {
        return this.removedEntries;
    }

    public static class Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(@Nonnull Map.Entry<K, V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

