/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.observable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.collections.delegate.DelegatingList;
import software.coley.collections.observable.ListChange;
import software.coley.collections.observable.ListChangeListener;

public class ObservableList<T>
extends DelegatingList<T> {
    private final List<ListChangeListener<T>> listeners = new ArrayList<ListChangeListener<T>>();

    public ObservableList() {
        this(ArrayList::new);
    }

    public ObservableList(@Nonnull Collection<T> items) {
        this(() -> new ArrayList(items));
    }

    public ObservableList(@Nonnull Supplier<List<T>> factory) {
        super(factory.get());
    }

    public void addChangeListener(@Nullable ListChangeListener<T> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean removeChangeListener(@Nullable ListChangeListener<T> listener) {
        return this.listeners.remove(listener);
    }

    private void post(@Nonnull ListChange<T> change) {
        this.listeners.forEach(listener -> listener.onListChanged(this, change));
    }

    @Override
    public boolean add(T t) {
        int from = this.size();
        super.add(t);
        this.post(ListChange.addition(t, from));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        boolean result;
        int index = this.indexOf(o);
        if (index >= 0 && (result = super.remove(o))) {
            this.post(ListChange.removal(o, index));
        }
        return false;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> c) {
        int from = this.size();
        boolean result = super.addAll(c);
        this.post(ListChange.addition(new ArrayList<T>(c), from));
        return result;
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends T> c) {
        boolean result = super.addAll(index, c);
        this.post(ListChange.addition(new ArrayList<T>(c), index));
        return result;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        boolean sectionResult;
        boolean result = false;
        ArrayList remaining = new ArrayList(c);
        ArrayList section = new ArrayList();
        int sectionStart = -1;
        while (!remaining.isEmpty()) {
            Object next = remaining.remove(0);
            int index = this.indexOf(next);
            if (index < 0) continue;
            if (section.isEmpty() || index == sectionStart + section.size()) {
                section.add(next);
                continue;
            }
            boolean sectionResult2 = super.removeAll(section);
            if (sectionResult2) {
                result = true;
                this.post(ListChange.removal(section, sectionStart));
            }
            section.clear();
            section.add(next);
            sectionStart = index;
        }
        if (!section.isEmpty() && (sectionResult = super.removeAll(section))) {
            result = true;
            this.post(ListChange.removal(section, sectionStart));
        }
        return result;
    }

    @Override
    public void clear() {
        ArrayList copy = new ArrayList(this);
        super.clear();
        this.post(ListChange.removal(copy, 0));
    }

    @Override
    public T set(int index, T element) {
        T result = super.set(index, element);
        this.post(ListChange.removal(element, index));
        this.post(ListChange.addition(result, index));
        return result;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.post(ListChange.addition(element, index));
    }

    @Override
    public T remove(int index) {
        Object result = super.remove(index);
        if (result != null) {
            this.post(ListChange.removal(result, index));
        }
        return result;
    }
}

