/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.observable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.collections.Maps;
import software.coley.collections.delegate.DelegatingMap;
import software.coley.collections.observable.MapChange;
import software.coley.collections.observable.MapChangeListener;

public class ObservableMap<K, V>
extends DelegatingMap<K, V> {
    private final List<MapChangeListener<K, V>> listeners = new ArrayList<MapChangeListener<K, V>>();

    public ObservableMap() {
        this(HashMap::new);
    }

    public ObservableMap(@Nonnull Map<K, V> items) {
        this(() -> new HashMap(items));
    }

    public ObservableMap(@Nonnull Supplier<Map<K, V>> factory) {
        super(factory.get());
    }

    public void addChangeListener(@Nullable MapChangeListener<K, V> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean removeChangeListener(@Nullable MapChangeListener<K, V> listener) {
        return this.listeners.remove(listener);
    }

    private void post(@Nonnull MapChange<K, V> change) {
        this.listeners.forEach((? super T listener) -> listener.onMapChanged(this, change));
    }

    @Override
    public V put(K key, V value) {
        V result = super.put(key, value);
        if (result != null) {
            this.post(MapChange.removal(Maps.of(key, result)));
        }
        this.post(MapChange.addition(Maps.of(key, value)));
        return result;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        HashMap replaced = new HashMap();
        this.entrySet().stream().filter(e -> m.containsKey(e.getKey())).forEach((? super T e) -> replaced.put(e.getKey(), e.getValue()));
        super.putAll(m);
        if (!replaced.isEmpty()) {
            this.post(MapChange.addition(replaced));
        }
        this.post(MapChange.addition(m));
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        HashMap<? super K, ? extends V> copy = new HashMap<K, V>(this);
        copy.replaceAll(function);
        this.putAll(copy);
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result = super.remove(key, value);
        if (result) {
            this.post(MapChange.removal(Maps.of(key, value)));
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        Object result = super.remove(key);
        if (result != null) {
            this.post(MapChange.removal(Maps.of(key, result)));
        }
        return result;
    }

    @Override
    public void clear() {
        HashMap copy = new HashMap(this);
        super.clear();
        this.post(MapChange.removal(copy));
    }
}

