/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.observable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.collections.delegate.DelegatingSet;
import software.coley.collections.observable.SetChange;
import software.coley.collections.observable.SetChangeListener;

public class ObservableSet<T>
extends DelegatingSet<T> {
    private final List<SetChangeListener<T>> listeners = new ArrayList<SetChangeListener<T>>();

    public ObservableSet() {
        this(HashSet::new);
    }

    public ObservableSet(@Nonnull Collection<T> items) {
        this(() -> new HashSet(items));
    }

    public ObservableSet(@Nonnull Supplier<Set<T>> factory) {
        super(factory.get());
    }

    public void addChangeListener(@Nullable SetChangeListener<T> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean removeChangeListener(@Nullable SetChangeListener<T> listener) {
        return this.listeners.remove(listener);
    }

    private void post(@Nonnull SetChange<T> change) {
        this.listeners.forEach(listener -> listener.onSetChanged(this, change));
    }

    @Override
    public boolean add(T t) {
        super.add(t);
        this.post(SetChange.addition(t));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result) {
            this.post(SetChange.removal(o));
        }
        return result;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> c) {
        boolean result = super.addAll(c);
        this.post(SetChange.addition(new HashSet<T>(c)));
        return result;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        boolean result = super.removeAll(c);
        this.post(SetChange.removal(new HashSet(c)));
        return result;
    }

    @Override
    public void clear() {
        HashSet copy = new HashSet(this);
        super.clear();
        this.post(SetChange.removal(copy));
    }
}

