/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.tree;

import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import software.coley.collections.delegate.DelegatingNavigableMap;
import software.coley.collections.tree.NavigableTree;
import software.coley.collections.tree.Tree;

public class NavigableTreeImpl<K, V>
extends DelegatingNavigableMap<K, Tree<K, V>>
implements NavigableTree<K, V> {
    private final Supplier<NavigableMap<K, ?>> delegateSupplier;
    private final NavigableTree<K, V> parent;
    private final V value;

    public NavigableTreeImpl() {
        this(null);
    }

    public NavigableTreeImpl(V value) {
        this(null, value);
    }

    public NavigableTreeImpl(NavigableTree<K, V> parent, V value) {
        this(TreeMap::new, parent, value);
    }

    public NavigableTreeImpl(Supplier<NavigableMap<K, ?>> delegateSupplier, NavigableTree<K, V> parent, V value) {
        this(delegateSupplier, delegateSupplier.get(), parent, value);
    }

    public NavigableTreeImpl(Supplier<NavigableMap<K, ?>> delegateSupplier, NavigableMap<K, ?> delegate, NavigableTree<K, V> parent, V value) {
        super(delegate);
        this.delegateSupplier = delegateSupplier;
        this.parent = parent;
        this.value = value;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public NavigableTree<K, V> getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public <T extends Tree<K, V>> T createSubTree(V value) {
        return (T)new NavigableTreeImpl<K, V>(this.delegateSupplier, this, value);
    }

    @Override
    @Nonnull
    public NavigableTree<K, V> descendingTree() {
        return this.from(this.descendingMap());
    }

    @Override
    @Nonnull
    public NavigableTree<K, V> subTree(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.from(this.subMap(fromKey, fromInclusive, toKey, toInclusive));
    }

    @Override
    @Nonnull
    public NavigableTree<K, V> subTree(K fromKey, K toKey) {
        return this.from((NavigableMap)this.subMap(fromKey, toKey));
    }

    @Override
    @Nonnull
    public NavigableTree<K, V> headTree(K toKey, boolean inclusive) {
        return this.from(this.headTree(toKey, inclusive));
    }

    @Override
    @Nonnull
    public NavigableTree<K, V> headTree(K toKey) {
        return this.from((NavigableMap)this.headMap(toKey));
    }

    @Override
    @Nonnull
    public NavigableTree<K, V> tailTree(K fromKey, boolean inclusive) {
        return this.from(this.tailMap(fromKey, inclusive));
    }

    @Override
    @Nonnull
    public NavigableTree<K, V> tailTree(K fromKey) {
        return this.from((NavigableMap)this.tailMap(fromKey));
    }

    private NavigableTree<K, V> from(NavigableMap<K, Tree<K, V>> subMap) {
        NavigableTreeImpl<K, Tree<K, V>> subTree = new NavigableTreeImpl<K, Tree<K, V>>(this.delegateSupplier, subMap, this, this.value);
        subTree.putAll(subMap);
        return subTree;
    }
}

