/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.tree;

import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import software.coley.collections.delegate.DelegatingSortedMap;
import software.coley.collections.tree.SortedTree;
import software.coley.collections.tree.Tree;

public class SortedTreeImpl<K, V>
extends DelegatingSortedMap<K, Tree<K, V>>
implements SortedTree<K, V> {
    private final Supplier<SortedMap<K, ?>> delegateSupplier;
    private final SortedTree<K, V> parent;
    private final V value;

    public SortedTreeImpl() {
        this(null);
    }

    public SortedTreeImpl(V value) {
        this(null, value);
    }

    public SortedTreeImpl(SortedTree<K, V> parent, V value) {
        this(TreeMap::new, parent, value);
    }

    public SortedTreeImpl(Supplier<SortedMap<K, ?>> delegateSupplier, SortedTree<K, V> parent, V value) {
        this(delegateSupplier, delegateSupplier.get(), parent, value);
    }

    public SortedTreeImpl(Supplier<SortedMap<K, ?>> delegateSupplier, SortedMap<K, ?> delegate, SortedTree<K, V> parent, V value) {
        super(delegate);
        this.delegateSupplier = delegateSupplier;
        this.parent = parent;
        this.value = value;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public SortedTree<K, V> getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public <T extends Tree<K, V>> T createSubTree(V value) {
        return (T)new SortedTreeImpl<K, V>(this.delegateSupplier, this, value);
    }

    @Override
    @Nonnull
    public SortedTree<K, V> subTree(K fromKey, K toKey) {
        return this.from(this.subMap(fromKey, toKey));
    }

    @Override
    @Nonnull
    public SortedTree<K, V> headTree(K toKey) {
        return this.from(this.headMap(toKey));
    }

    @Override
    @Nonnull
    public SortedTree<K, V> tailTree(K fromKey) {
        return this.from(this.tailMap(fromKey));
    }

    private SortedTree<K, V> from(SortedMap<K, Tree<K, V>> subMap) {
        SortedTreeImpl<K, Tree<K, V>> subTree = new SortedTreeImpl<K, Tree<K, V>>(this.delegateSupplier, subMap, this, this.value);
        subTree.putAll(subMap);
        return subTree;
    }
}

