/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.tree;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.collections.Sets;

public interface Tree<K, V>
extends Map<K, Tree<K, V>> {
    @Nullable
    public V getValue();

    @Nullable
    public Tree<K, V> getParent();

    @Nonnull
    public <T extends Tree<K, V>> T createSubTree(@Nullable V var1);

    @Nullable
    default public <T extends Tree<K, V>> T putTree(K key, V value) {
        T subTree = this.createSubTree(value);
        return (T)((Tree)this.put(key, subTree));
    }

    @Nonnull
    default public <T extends Tree<K, V>> Set<T> getBranches() {
        return this.values().stream().filter(Tree::isBranch).collect(Collectors.toSet());
    }

    @Nonnull
    default public <T extends Tree<K, V>> Set<T> getLeaves() {
        return this.values().stream().filter(Tree::isLeaf).collect(Collectors.toSet());
    }

    @Nonnull
    default public <T extends Tree<K, V>> Set<T> getAllLeaves() {
        if (this.isLeaf()) {
            return Sets.of(this);
        }
        HashSet values = new HashSet();
        this.values().forEach((? super T t) -> values.addAll(t.getAllLeaves()));
        return values;
    }

    default public boolean isRoot() {
        return this.getParent() == null;
    }

    default public boolean isLeaf() {
        return this.size() == 0;
    }

    default public boolean isBranch() {
        return this.size() > 0;
    }
}

