/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import software.coley.collections.delegate.DelegatingMap;
import software.coley.collections.tree.Tree;

public class TreeImpl<K, V>
extends DelegatingMap<K, Tree<K, V>>
implements Tree<K, V> {
    private final Supplier<Map<K, ?>> delegateSupplier;
    private final Tree<K, V> parent;
    private final V value;

    public TreeImpl() {
        this(null, null);
    }

    public TreeImpl(V value) {
        this(null, value);
    }

    public TreeImpl(Tree<K, V> parent, V value) {
        this(HashMap::new, parent, value);
    }

    public TreeImpl(Supplier<Map<K, ?>> delegateSupplier, Tree<K, V> parent, V value) {
        super(delegateSupplier.get());
        this.delegateSupplier = delegateSupplier;
        this.parent = parent;
        this.value = value;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public Tree<K, V> getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public <T extends Tree<K, V>> T createSubTree(V value) {
        return (T)new TreeImpl<K, V>(this.delegateSupplier, this, value);
    }
}

