/*
 * Decompiled with CFR 0.152.
 */
package software.coley.collections.tuple;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class Pair<L, R> {
    private final L left;
    private final R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public Pair<L, R> withLeft(L newLeft) {
        return new Pair<L, R>(newLeft, this.right);
    }

    public Pair<L, R> withRight(R newRight) {
        return new Pair<L, R>(this.left, newRight);
    }

    public Pair<R, L> flip() {
        return new Pair<R, L>(this.right, this.left);
    }

    public <LM> Pair<LM, R> mapLeft(Function<L, LM> mapper) {
        return new Pair<LM, R>(mapper.apply(this.left), this.right);
    }

    public <RM> Pair<L, RM> mapRight(Function<R, RM> mapper) {
        return new Pair<L, RM>(this.left, mapper.apply(this.right));
    }

    public <LM, RM> Pair<LM, RM> mapBoth(Function<L, LM> leftMapper, Function<R, RM> rightMapper) {
        return new Pair<LM, RM>(leftMapper.apply(this.left), rightMapper.apply(this.right));
    }

    public boolean mapContainsKeyValue(Map<L, R> map) {
        if (map.containsKey(this.left)) {
            return Objects.equals(map.get(this.left), this.right);
        }
        return false;
    }

    public boolean hasLeft() {
        return this.left != null;
    }

    public boolean hasRight() {
        return this.right != null;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.left, pair.left) && Objects.equals(this.right, pair.right);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair{left=" + this.left + ", right=" + this.right + '}';
    }
}

