/*
 * Decompiled with CFR 0.152.
 */
package software.coley.observables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import software.coley.observables.BoundTargetSetException;
import software.coley.observables.BoundValueSetException;
import software.coley.observables.ChangeListener;
import software.coley.observables.Observable;

public abstract class AbstractObservable<T>
implements Observable<T> {
    private final Map<ChangeListener<T>, ChangeListener<T>> asyncChangeListenerLookup = new IdentityHashMap<ChangeListener<T>, ChangeListener<T>>();
    private final List<ChangeListener<T>> changeListeners = new ArrayList<ChangeListener<T>>();
    private final Set<Observable> bindReceivers = Collections.newSetFromMap(new IdentityHashMap());
    private final Function<Object, T> boundValueMapper;
    private Observable<?> bindTarget;
    private T value;

    public AbstractObservable(T value) {
        this(value, null);
    }

    public <I> AbstractObservable(T value, Function<I, T> boundValueMapper) {
        this.boundValueMapper = boundValueMapper;
        this.value = value;
    }

    @Override
    public final T getValue() {
        return this.value;
    }

    @Override
    public final void setValue(T newValue) {
        if (this.bindTarget != null) {
            throw new BoundValueSetException(this);
        }
        this.validateNewValue(newValue);
        this.set(newValue);
    }

    @Override
    public <S extends Observable<?>> S bindTo(Observable<?> observable) {
        Objects.requireNonNull(observable, "Observable target must not be null");
        if (this.bindTarget != null) {
            if (this.bindTarget != observable) {
                return (S)this;
            }
            throw new BoundTargetSetException(this);
        }
        this.bindTarget = observable;
        observable.getBoundReceivers().add(this);
        return (S)this;
    }

    @Override
    public boolean unbind(Observable<T> observable) {
        this.bindTarget = null;
        return observable.getBoundReceivers().remove(this);
    }

    @Override
    public Set<Observable> getBoundReceivers() {
        return this.bindReceivers;
    }

    @Override
    public Function<Object, T> getBoundValueMapper() {
        return this.boundValueMapper;
    }

    @Override
    public void addChangeListener(ChangeListener<T> listener) {
        Objects.requireNonNull(listener, "Listener must not be null");
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public void addAsyncChangeListener(ChangeListener<T> listener, Executor executor) {
        Objects.requireNonNull(listener, "Listener must not be null");
        Objects.requireNonNull(executor, "Executor service must not be null");
        if (!this.asyncChangeListenerLookup.containsKey(listener)) {
            ChangeListener<Object> asyncListener = (observable, oldValue, newValue) -> CompletableFuture.runAsync(() -> listener.changed(observable, oldValue, newValue), executor);
            this.asyncChangeListenerLookup.put(listener, asyncListener);
            this.changeListeners.add(asyncListener);
        }
    }

    @Override
    public boolean removeChangeListener(ChangeListener<T> listener) {
        ChangeListener<T> asyncListener = this.asyncChangeListenerLookup.remove(listener);
        if (asyncListener != null) {
            return this.changeListeners.remove(asyncListener);
        }
        return this.changeListeners.remove(listener);
    }

    protected void validateNewValue(T newValue) {
    }

    private void set(T newValue) {
        T oldValue = this.value;
        this.value = newValue;
        if (newValue != oldValue) {
            this.changeListeners.forEach(l -> l.changed(this, oldValue, newValue));
            this.bindReceivers.forEach(o -> {
                if (!(o instanceof AbstractObservable)) {
                    throw new UnsupportedOperationException("Receiver does not implement internal set/map operations");
                }
                AbstractObservable ao = (AbstractObservable)o;
                ao.set(ao.map(newValue));
            });
        }
    }

    private T map(Object value) {
        return (T)(this.boundValueMapper == null ? value : this.boundValueMapper.apply(value));
    }
}

