/*
 * Decompiled with CFR 0.152.
 */
package software.coley.observables;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import software.coley.observables.ChangeListener;
import software.coley.observables.ObservableBoolean;
import software.coley.observables.ObservableByte;
import software.coley.observables.ObservableCharacter;
import software.coley.observables.ObservableDouble;
import software.coley.observables.ObservableFloat;
import software.coley.observables.ObservableInteger;
import software.coley.observables.ObservableLong;
import software.coley.observables.ObservableObject;
import software.coley.observables.ObservableShort;
import software.coley.observables.ObservableString;

public interface Observable<T> {
    public void setValue(T var1);

    public T getValue();

    default public boolean hasValue() {
        return this.getValue() != null;
    }

    public void addChangeListener(ChangeListener<T> var1);

    public void addAsyncChangeListener(ChangeListener<T> var1, Executor var2);

    public boolean removeChangeListener(ChangeListener<T> var1);

    public <S extends Observable<?>> S bindTo(Observable<?> var1);

    public boolean unbind(Observable<T> var1);

    public Set<Observable> getBoundReceivers();

    public Function<Object, T> getBoundValueMapper();

    default public <R> R unboxingMap(Function<T, R> valueMapper) {
        return valueMapper.apply(this.getValue());
    }

    default public <R> ObservableObject<R> mapObject(Function<T, R> valueMapper) {
        ObservableObject<R> observable = new ObservableObject<R>(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableString mapString() {
        return this.mapString(String::valueOf);
    }

    default public ObservableString mapFormattedString(String format) {
        return this.mapString(v -> String.format(format, this.getValue()));
    }

    default public ObservableString mapString(Function<T, String> valueMapper) {
        ObservableString observable = new ObservableString(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableBoolean mapBoolean(Function<T, Boolean> valueMapper) {
        ObservableBoolean observable = new ObservableBoolean(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableByte mapByte(Function<T, Byte> valueMapper) {
        ObservableByte observable = new ObservableByte(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableCharacter mapCharacter(Function<T, Character> valueMapper) {
        ObservableCharacter observable = new ObservableCharacter(valueMapper.apply(this.getValue()).charValue(), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableDouble mapDouble(Function<T, Double> valueMapper) {
        ObservableDouble observable = new ObservableDouble(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableFloat mapFloat(Function<T, Float> valueMapper) {
        ObservableFloat observable = new ObservableFloat(valueMapper.apply(this.getValue()).floatValue(), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableInteger mapInt(Function<T, Integer> valueMapper) {
        ObservableInteger observable = new ObservableInteger(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableLong mapLong(Function<T, Long> valueMapper) {
        ObservableLong observable = new ObservableLong(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }

    default public ObservableShort mapShort(Function<T, Short> valueMapper) {
        ObservableShort observable = new ObservableShort(valueMapper.apply(this.getValue()), valueMapper);
        observable.bindTo(this);
        return observable;
    }
}

