/*
 * Decompiled with CFR 0.152.
 */
package software.coley.observables;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import software.coley.observables.ObservableObject;

public class ObservableCollection<T, C extends Collection<T>>
extends ObservableObject<C>
implements Collection<T> {
    protected final Supplier<C> collectionConstructor;

    public ObservableCollection(Supplier<C> collectionConstructor) {
        this((Collection)collectionConstructor.get(), null, collectionConstructor);
    }

    public ObservableCollection(C value, Supplier<C> collectionConstructor) {
        this(value, null, collectionConstructor);
    }

    public <I> ObservableCollection(C value, Function<I, C> boundValueMapper, Supplier<C> collectionConstructor) {
        super(value, boundValueMapper);
        this.collectionConstructor = collectionConstructor;
    }

    @Override
    public int size() {
        return ((Collection)this.getValue()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.getValue()).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((Collection)this.getValue()).contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return ((Collection)this.getValue()).iterator();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<T> each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.next())) continue;
            each.remove();
            removed = true;
        }
        if (removed) {
            Collection copy = (Collection)this.collectionConstructor.get();
            copy.addAll((Collection)this.getValue());
            this.setValue(copy);
        }
        return removed;
    }

    @Override
    public Object[] toArray() {
        return ((Collection)this.getValue()).toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return ((Collection)this.getValue()).toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((Collection)this.getValue()).containsAll(c);
    }

    @Override
    public boolean add(T t) {
        Collection collection = (Collection)this.getValue();
        Collection newCollection = (Collection)this.collectionConstructor.get();
        newCollection.addAll(collection);
        boolean result = newCollection.add(t);
        this.setValue(newCollection);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        Collection collection = (Collection)this.getValue();
        Collection newCollection = (Collection)this.collectionConstructor.get();
        newCollection.addAll(collection);
        boolean result = newCollection.remove(o);
        this.setValue(newCollection);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Collection collection = (Collection)this.getValue();
        Collection newCollection = (Collection)this.collectionConstructor.get();
        newCollection.addAll(collection);
        boolean result = newCollection.addAll(c);
        this.setValue(newCollection);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Collection collection = (Collection)this.getValue();
        Collection newCollection = (Collection)this.collectionConstructor.get();
        newCollection.addAll(collection);
        boolean result = newCollection.removeAll(c);
        this.setValue(newCollection);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Collection collection = (Collection)this.getValue();
        Collection newCollection = (Collection)this.collectionConstructor.get();
        newCollection.addAll(collection);
        boolean result = newCollection.retainAll(c);
        this.setValue(newCollection);
        return result;
    }

    @Override
    public void clear() {
        this.setValue((Collection)this.collectionConstructor.get());
    }
}

