/*
 * Decompiled with CFR 0.152.
 */
package software.coley.observables;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Supplier;
import software.coley.observables.ObservableCollection;

public class ObservableList<T, L extends List<T>>
extends ObservableCollection<T, L>
implements List<T> {
    public ObservableList(Supplier<L> listConstructor) {
        super(listConstructor);
    }

    public ObservableList(L value, Supplier<L> collectionConstructor) {
        super(value, collectionConstructor);
    }

    public <I> ObservableList(L value, Function<I, L> boundValueMapper, Supplier<L> collectionConstructor) {
        super(value, boundValueMapper, collectionConstructor);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        List list = (List)this.getValue();
        List newList = (List)this.collectionConstructor.get();
        newList.addAll(list);
        boolean result = newList.addAll(c);
        this.setValue(newList);
        return result;
    }

    @Override
    public T get(int index) {
        return (T)((List)this.getValue()).get(index);
    }

    @Override
    public T set(int index, T element) {
        List list = (List)this.getValue();
        List newList = (List)this.collectionConstructor.get();
        newList.addAll(list);
        T result = newList.set(index, element);
        this.setValue(newList);
        return result;
    }

    @Override
    public void add(int index, T element) {
        List list = (List)this.getValue();
        List newList = (List)this.collectionConstructor.get();
        newList.addAll(list);
        newList.add(index, element);
        this.setValue(newList);
    }

    @Override
    public T remove(int index) {
        List list = (List)this.getValue();
        List newList = (List)this.collectionConstructor.get();
        newList.addAll(list);
        Object result = newList.remove(index);
        this.setValue(newList);
        return (T)result;
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.getValue()).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.getValue()).lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return ((List)this.getValue()).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return ((List)this.getValue()).listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return ((List)this.getValue()).subList(fromIndex, toIndex);
    }
}

