/*
 * Decompiled with CFR 0.152.
 */
package software.coley.observables;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import software.coley.observables.ObservableObject;

public class ObservableMap<K, V, M extends Map<K, V>>
extends ObservableObject<M>
implements Map<K, V> {
    private final Supplier<M> mapConstructor;

    public ObservableMap(Supplier<M> mapConstructor) {
        this((Map)mapConstructor.get(), null, mapConstructor);
    }

    public ObservableMap(M value, Supplier<M> mapConstructor) {
        this(value, null, mapConstructor);
    }

    public <I> ObservableMap(M value, Function<I, M> boundValueMapper, Supplier<M> mapConstructor) {
        super(value, boundValueMapper);
        this.mapConstructor = mapConstructor;
    }

    @Override
    public int size() {
        return ((Map)this.getValue()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.getValue()).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((Map)this.getValue()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((Map)this.getValue()).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return ((Map)this.getValue()).get(key);
    }

    @Override
    public V put(K key, V value) {
        Map map = (Map)this.getValue();
        Map newMap = (Map)this.mapConstructor.get();
        newMap.putAll(map);
        V replaced = newMap.put(key, value);
        this.setValue(newMap);
        return replaced;
    }

    @Override
    public V remove(Object key) {
        Map map = (Map)this.getValue();
        Map newMap = (Map)this.mapConstructor.get();
        newMap.putAll(map);
        Object removed = newMap.remove(key);
        this.setValue(newMap);
        return removed;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Map map = (Map)this.getValue();
        Map newMap = (Map)this.mapConstructor.get();
        newMap.putAll(map);
        newMap.putAll(m);
        this.setValue(newMap);
    }

    @Override
    public void clear() {
        this.setValue((Map)this.mapConstructor.get());
    }

    @Override
    public Set<K> keySet() {
        return ((Map)this.getValue()).keySet();
    }

    @Override
    public Collection<V> values() {
        return ((Map)this.getValue()).values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ((Map)this.getValue()).entrySet();
    }
}

