/*
 * Decompiled with CFR 0.152.
 */
package software.coley.observables;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.coley.observables.AbstractObservable;
import software.coley.observables.ObservableByte;
import software.coley.observables.ObservableDouble;
import software.coley.observables.ObservableFloat;
import software.coley.observables.ObservableInteger;
import software.coley.observables.ObservableLong;
import software.coley.observables.ObservableShort;
import software.coley.observables.util.NumberUtil;

public class ObservableNumber<N extends Number>
extends AbstractObservable<N> {
    public ObservableNumber(N value) {
        super(value);
    }

    public <I> ObservableNumber(N value, Function<I, N> boundValueMapper) {
        super(value, boundValueMapper);
        Objects.requireNonNull(value, "Numeric values cannot be null");
    }

    @Override
    protected void validateNewValue(N newValue) {
        Objects.requireNonNull(newValue, "Numeric values cannot be null");
    }

    public N add(N value) {
        return this.setNumberValue(NumberUtil.add((Number)this.getValue(), value).getValue());
    }

    public N subtract(N value) {
        return this.setNumberValue(NumberUtil.sub((Number)this.getValue(), value).getValue());
    }

    public N multiply(N value) {
        return this.setNumberValue(NumberUtil.mul((Number)this.getValue(), value).getValue());
    }

    public N divide(N value) {
        return this.setNumberValue(NumberUtil.div((Number)this.getValue(), value).getValue());
    }

    public N remainder(N value) {
        return this.setNumberValue(NumberUtil.rem((Number)this.getValue(), value).getValue());
    }

    public N and(N value) {
        return this.setNumberValue(NumberUtil.add((Number)this.getValue(), value).getValue());
    }

    public N or(N value) {
        return this.setNumberValue(NumberUtil.or((Number)this.getValue(), value).getValue());
    }

    public N xor(N value) {
        return this.setNumberValue(NumberUtil.xor((Number)this.getValue(), value).getValue());
    }

    public N shiftLeft(N value) {
        return this.setNumberValue(NumberUtil.shiftLeft((Number)this.getValue(), value).getValue());
    }

    public N shiftRight(N value) {
        return this.setNumberValue(NumberUtil.shiftRight((Number)this.getValue(), value).getValue());
    }

    public N shiftRightUnsigned(N value) {
        return this.setNumberValue(NumberUtil.shiftRightU((Number)this.getValue(), value).getValue());
    }

    public N negate() {
        return this.setNumberValue(NumberUtil.neg((Number)this.getValue()).getValue());
    }

    public ObservableByte mapAsByte() {
        Function<Number, Byte> valueMapper = Number::byteValue;
        return (ObservableByte)new ObservableByte(valueMapper.apply((Number)this.getValue()), valueMapper).bindTo(this);
    }

    public ObservableDouble mapAsDouble() {
        Function<Number, Double> valueMapper = Number::doubleValue;
        return (ObservableDouble)new ObservableDouble(valueMapper.apply((Number)this.getValue()), valueMapper).bindTo(this);
    }

    public ObservableFloat mapAsFloat() {
        Function<Number, Float> valueMapper = Number::floatValue;
        return (ObservableFloat)new ObservableFloat(valueMapper.apply((Number)this.getValue()).floatValue(), valueMapper).bindTo(this);
    }

    public ObservableInteger mapAsInt() {
        Function<Number, Integer> valueMapper = Number::intValue;
        return (ObservableInteger)new ObservableInteger(valueMapper.apply((Number)this.getValue()), valueMapper).bindTo(this);
    }

    public ObservableLong mapLong() {
        Function<Number, Long> valueMapper = Number::longValue;
        return (ObservableLong)new ObservableLong(valueMapper.apply((Number)this.getValue()), valueMapper).bindTo(this);
    }

    public ObservableShort mapAsShort() {
        Function<Number, Short> valueMapper = Number::shortValue;
        return (ObservableShort)new ObservableShort(valueMapper.apply((Number)this.getValue()), valueMapper).bindTo(this);
    }

    private ObservableNumber<? extends Number> mapFunction(N value, BiFunction<Number, Number, NumberUtil.Result> func) {
        Function<Number, Number> valueMapper = in -> ((NumberUtil.Result)func.apply((Number)in, (Number)value)).getValue();
        ObservableNumber<Number> observable = func.apply((Number)this.getValue(), (Number)value).toObservable(valueMapper);
        observable.bindTo(this);
        return observable;
    }

    public ObservableNumber<? extends Number> mapNegate() {
        Function<Number, Number> valueMapper = in -> NumberUtil.neg(in).getValue();
        ObservableNumber<Number> observable = NumberUtil.neg((Number)this.getValue()).toObservable(valueMapper);
        observable.bindTo(this);
        return observable;
    }

    public ObservableNumber<? extends Number> mapCompare(N value) {
        return this.mapFunction(value, NumberUtil::cmp);
    }

    public ObservableNumber<? extends Number> mapSubtract(N value) {
        return this.mapFunction(value, NumberUtil::sub);
    }

    public ObservableNumber<? extends Number> mapAdd(N value) {
        return this.mapFunction(value, NumberUtil::add);
    }

    public ObservableNumber<? extends Number> mapMultiply(N value) {
        return this.mapFunction(value, NumberUtil::mul);
    }

    public ObservableNumber<? extends Number> mapDivide(N value) {
        return this.mapFunction(value, NumberUtil::div);
    }

    public ObservableNumber<? extends Number> mapRemainder(N value) {
        return this.mapFunction(value, NumberUtil::rem);
    }

    public ObservableNumber<? extends Number> mapAnd(N value) {
        return this.mapFunction(value, NumberUtil::and);
    }

    public ObservableNumber<? extends Number> mapOr(N value) {
        return this.mapFunction(value, NumberUtil::or);
    }

    public ObservableNumber<? extends Number> mapXor(N value) {
        return this.mapFunction(value, NumberUtil::xor);
    }

    public ObservableNumber<? extends Number> mapShiftLeft(N value) {
        return this.mapFunction(value, NumberUtil::shiftLeft);
    }

    public ObservableNumber<? extends Number> mapShiftRight(N value) {
        return this.mapFunction(value, NumberUtil::shiftRight);
    }

    public ObservableNumber<? extends Number> mapShiftRightUnsigned(N value) {
        return this.mapFunction(value, NumberUtil::shiftRightU);
    }

    private N setNumberValue(Number value) {
        Number actual = value;
        this.setValue(actual);
        return (N)actual;
    }
}

