/*
 * Decompiled with CFR 0.152.
 */
package software.coley.observables.util;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.coley.observables.ObservableByte;
import software.coley.observables.ObservableDouble;
import software.coley.observables.ObservableFloat;
import software.coley.observables.ObservableInteger;
import software.coley.observables.ObservableLong;
import software.coley.observables.ObservableNumber;
import software.coley.observables.ObservableShort;

public class NumberUtil {
    private static final Map<Class<? extends Number>, BiFunction<Number, Function<Object, ? extends Number>, ? extends ObservableNumber>> map = new IdentityHashMap<Class<? extends Number>, BiFunction<Number, Function<Object, ? extends Number>, ? extends ObservableNumber>>();

    public static Result parse(String input) {
        String text = input.trim().toUpperCase();
        Result value = text.indexOf(46) > 0 ? NumberUtil.parseDecimal(text) : (text.endsWith("L") && text.startsWith("0X") ? new Result(Long.parseLong(text.substring(2, text.indexOf("L")), 16), Long.class) : (text.endsWith("L") ? new Result(Long.parseLong(text.substring(0, text.indexOf("L"))), Long.class) : (text.startsWith("0X") ? new Result(Integer.parseInt(text.substring(2), 16), Integer.class) : (text.endsWith("F") ? new Result(Float.valueOf(Float.parseFloat(text.substring(0, text.indexOf("F")))), Float.class) : (text.endsWith("D") || text.contains(".") ? new Result(Double.parseDouble(text.substring(0, text.indexOf("D"))), Double.class) : new Result(Integer.parseInt(text), Integer.class))))));
        return value;
    }

    private static Result parseDecimal(String text) {
        if ((text = text.toUpperCase()).endsWith("F")) {
            return new Result(Float.valueOf(Float.parseFloat(text.substring(0, text.indexOf("F")))), Float.class);
        }
        if (text.endsWith("D")) {
            text = text.substring(text.length() - 1);
        }
        if (text.contains(".")) {
            return new Result(Double.parseDouble(text), Double.class);
        }
        return new Result(Integer.parseInt(text), Integer.class);
    }

    public static Result cmp(Number left, Number right) {
        if (right instanceof Double || left instanceof Double) {
            return new Result(Double.compare(left.doubleValue(), right.doubleValue()), Integer.class);
        }
        if (right instanceof Float || left instanceof Float) {
            return new Result(Float.compare(left.floatValue(), right.floatValue()), Integer.class);
        }
        if (right instanceof Long || left instanceof Long) {
            return new Result(Long.compare(left.longValue(), right.longValue()), Integer.class);
        }
        return new Result(Integer.compare(left.intValue(), right.intValue()), Integer.class);
    }

    public static Result sub(Number first, Number second) {
        if (second instanceof Double || first instanceof Double) {
            return new Result(first.doubleValue() - second.doubleValue(), Double.class);
        }
        if (second instanceof Float || first instanceof Float) {
            return new Result(Float.valueOf(first.floatValue() - second.floatValue()), Float.class);
        }
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() - second.longValue(), Long.class);
        }
        return new Result(first.intValue() - second.intValue(), Integer.class);
    }

    public static Result add(Number first, Number second) {
        if (second instanceof Double || first instanceof Double) {
            return new Result(first.doubleValue() + second.doubleValue(), Double.class);
        }
        if (second instanceof Float || first instanceof Float) {
            return new Result(Float.valueOf(first.floatValue() + second.floatValue()), Float.class);
        }
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() + second.longValue(), Long.class);
        }
        return new Result(first.intValue() + second.intValue(), Integer.class);
    }

    public static Result mul(Number first, Number second) {
        if (second instanceof Double || first instanceof Double) {
            return new Result(first.doubleValue() * second.doubleValue(), Double.class);
        }
        if (second instanceof Float || first instanceof Float) {
            return new Result(Float.valueOf(first.floatValue() * second.floatValue()), Float.class);
        }
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() * second.longValue(), Long.class);
        }
        return new Result(first.intValue() * second.intValue(), Integer.class);
    }

    public static Result div(Number first, Number second) {
        if (second instanceof Double || first instanceof Double) {
            return new Result(first.doubleValue() / second.doubleValue(), Double.class);
        }
        if (second instanceof Float || first instanceof Float) {
            return new Result(Float.valueOf(first.floatValue() / second.floatValue()), Float.class);
        }
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() / second.longValue(), Long.class);
        }
        return new Result(first.intValue() / second.intValue(), Integer.class);
    }

    public static Result rem(Number first, Number second) {
        if (second instanceof Double || first instanceof Double) {
            return new Result(first.doubleValue() % second.doubleValue(), Double.class);
        }
        if (second instanceof Float || first instanceof Float) {
            return new Result(Float.valueOf(first.floatValue() % second.floatValue()), Float.class);
        }
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() % second.longValue(), Long.class);
        }
        return new Result(first.intValue() % second.intValue(), Integer.class);
    }

    public static Result and(Number first, Number second) {
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() & second.longValue(), Long.class);
        }
        return new Result(first.intValue() & second.intValue(), Integer.class);
    }

    public static Result or(Number first, Number second) {
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() | second.longValue(), Long.class);
        }
        return new Result(first.intValue() | second.intValue(), Integer.class);
    }

    public static Result xor(Number first, Number second) {
        if (second instanceof Long || first instanceof Long) {
            return new Result(first.longValue() ^ second.longValue(), Long.class);
        }
        return new Result(first.intValue() ^ second.intValue(), Integer.class);
    }

    public static Result neg(Number value) {
        if (value instanceof Double) {
            return new Result(-value.doubleValue(), Double.class);
        }
        if (value instanceof Float) {
            return new Result(Float.valueOf(-value.floatValue()), Float.class);
        }
        if (value instanceof Long) {
            return new Result(-value.longValue(), Long.class);
        }
        return new Result(-value.intValue(), Integer.class);
    }

    public static Result shiftLeft(Number value, Number shift) {
        if (value instanceof Long) {
            return new Result(value.longValue() << (int)shift.longValue(), Long.class);
        }
        return new Result(value.intValue() << shift.intValue(), Integer.class);
    }

    public static Result shiftRight(Number value, Number shift) {
        if (value instanceof Long) {
            return new Result(value.longValue() >> (int)shift.longValue(), Long.class);
        }
        return new Result(value.intValue() >> shift.intValue(), Integer.class);
    }

    public static Result shiftRightU(Number value, Number shift) {
        if (value instanceof Long) {
            return new Result(value.longValue() >>> (int)shift.longValue(), Long.class);
        }
        return new Result(value.intValue() >>> shift.intValue(), Integer.class);
    }

    static {
        map.put(Byte.class, (value, valueMapper) -> new ObservableByte(value.byteValue(), valueMapper));
        map.put(Double.class, (value, valueMapper) -> new ObservableDouble(value.doubleValue(), valueMapper));
        map.put(Float.class, (value, valueMapper) -> new ObservableFloat(value.floatValue(), valueMapper));
        map.put(Integer.class, (value, valueMapper) -> new ObservableInteger(value.intValue(), valueMapper));
        map.put(Long.class, (value, valueMapper) -> new ObservableLong(value.longValue(), valueMapper));
        map.put(Short.class, (value, valueMapper) -> new ObservableShort(value.shortValue(), valueMapper));
    }

    public static class Result {
        private final Number value;
        private final Class<? extends Number> type;

        public Result(Number value, Class<? extends Number> type) {
            this.value = value;
            this.type = type;
        }

        public <I extends Number, N extends Number> ObservableNumber<N> toObservable(Function<I, N> valueMapper) {
            return (ObservableNumber)((BiFunction)map.get(this.type)).apply(this.value, valueMapper);
        }

        public Number getValue() {
            return this.value;
        }

        public Class<? extends Number> getType() {
            return this.type;
        }
    }
}

