/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.coley.instrument.Server;
import software.coley.instrument.io.ByteBufferAllocator;
import software.coley.instrument.message.MessageFactory;
import software.coley.instrument.sock.ChannelHandler;
import software.coley.instrument.util.Logger;

public class Agent {
    private static Server server;

    public static void premain(String agentArgs, Instrumentation instrumentation) throws Exception {
        Agent.agent(agentArgs == null ? "" : agentArgs, instrumentation);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) throws Exception {
        Agent.agent(agentArgs == null ? "" : agentArgs, instrumentation);
    }

    private static void agent(String agentArgs, Instrumentation instrumentation) throws IOException {
        if (agentArgs.contains("error")) {
            Logger.level = 0;
        } else if (agentArgs.contains("warn")) {
            Logger.level = 1;
        } else if (agentArgs.contains("info")) {
            Logger.level = 2;
        } else if (agentArgs.contains("debug")) {
            Logger.level = 3;
        }
        if (agentArgs.contains("namelessThreads")) {
            ChannelHandler.threadNameEventHandle = null;
            ChannelHandler.threadNameEventLoop = null;
            ChannelHandler.threadNameRead = null;
            ChannelHandler.threadNameWrite = null;
        }
        if (server == null || server.isClosed()) {
            Logger.prefix = "[Server]";
            int port = Agent.getPort(agentArgs);
            server = Server.open(instrumentation, new InetSocketAddress("localhost", port), ByteBufferAllocator.HEAP, MessageFactory.create());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> server.close()));
        }
    }

    private static int getPort(String agentArgs) {
        if (agentArgs.contains("port=")) {
            try {
                int startPos = agentArgs.indexOf("port=") + 5;
                Matcher matcher = Pattern.compile("\\d+").matcher(agentArgs);
                if (matcher.find(startPos)) {
                    String matched = matcher.group();
                    return Integer.parseInt(matched);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 25252;
    }
}

