/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import software.coley.instrument.Agent;
import software.coley.instrument.Server;
import software.coley.instrument.data.BasicClassLoaderInfo;
import software.coley.instrument.data.ClassData;
import software.coley.instrument.data.ServerClassLoaderInfo;
import software.coley.instrument.message.broadcast.BroadcastClassMessage;
import software.coley.instrument.message.broadcast.BroadcastClassloaderMessage;
import software.coley.instrument.util.Logger;
import software.coley.instrument.util.Streams;

public final class InstrumentationHelper
implements ClassFileTransformer {
    private final Map<Integer, LoaderData> loaders = new HashMap<Integer, LoaderData>();
    private final Lock lock = new ReentrantLock();
    private final Instrumentation instrumentation;
    private final Server server;

    public InstrumentationHelper(Server server, Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.server = server;
        if (instrumentation != null) {
            this.populateExisting();
            instrumentation.addTransformer(this, true);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (className != null && !InstrumentationHelper.isSelf(protectionDomain)) {
            this.getOrCreateDataWrapper(loader).update(className, classBeingRedefined, classfileBuffer);
        }
        return classfileBuffer;
    }

    private static boolean isSelf(ProtectionDomain protectionDomain) {
        return Agent.class.getProtectionDomain() == protectionDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoaderData getOrCreateDataWrapper(ClassLoader loader) {
        this.lock.lock();
        try {
            if (loader == null) {
                LoaderData loaderData = this.loaders.computeIfAbsent(0, i -> new LoaderData(ServerClassLoaderInfo.BOOTSTRAP));
                return loaderData;
            }
            if (loader == ServerClassLoaderInfo.SCL) {
                LoaderData loaderData = this.loaders.computeIfAbsent(1, i -> new LoaderData(ServerClassLoaderInfo.SYSTEM));
                return loaderData;
            }
            int id = loader.hashCode();
            LoaderData loaderData = this.loaders.computeIfAbsent(id, i -> new LoaderData(ServerClassLoaderInfo.fromLoader(loader)));
            return loaderData;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void populateExisting() {
        for (Class cls : this.instrumentation.getAllLoadedClasses()) {
            String name;
            InputStream clsStream;
            if (InstrumentationHelper.isSelf(cls.getProtectionDomain()) || (clsStream = ClassLoader.getSystemResourceAsStream((name = cls.getName().replace('.', '/')) + ".class")) == null) continue;
            ClassLoader loader = cls.getClassLoader();
            try {
                byte[] code = Streams.readStream(clsStream);
                this.getOrCreateDataWrapper(loader).update(name, cls, code);
            }
            catch (IOException e) {
                Logger.debug("Failed to read existing class: " + name);
            }
        }
    }

    public Collection<ServerClassLoaderInfo> getLoaders() {
        return new HashSet<LoaderData>(this.loaders.values()).stream().map(i -> ((LoaderData)i).loaderInfo).sorted(Comparator.comparingInt(BasicClassLoaderInfo::getId)).collect(Collectors.toList());
    }

    public Set<String> getLoaderClasses(int loaderId) {
        LoaderData data = this.loaders.get(loaderId);
        if (data == null) {
            return Collections.emptySet();
        }
        return data.bytecode.keySet();
    }

    public byte[] getClassBytecode(int loaderId, String className) {
        LoaderData data = this.loaders.get(loaderId);
        if (data == null) {
            return null;
        }
        return (byte[])data.bytecode.get(className);
    }

    public ClassData getClassData(int loaderId, String name) {
        byte[] code = this.getClassBytecode(loaderId, name);
        return new ClassData(name, loaderId, code);
    }

    public String redefineClass(int loaderId, String className, byte[] code) throws UnmodifiableClassException, ClassNotFoundException {
        LoaderData data = this.loaders.get(loaderId);
        if (data == null) {
            return "Unknown classloader " + loaderId;
        }
        Class<?> ref = (Class<?>)data.refs.get(className);
        if (ref == null) {
            ref = data.tryLoad(className);
        }
        if (ref == null) {
            return "Unknown class '" + className + "' in loader " + loaderId;
        }
        ClassDefinition def = new ClassDefinition(ref, code);
        this.instrumentation.redefineClasses(def);
        data.bytecode.put(className, code);
        return null;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public Instrumentation instrumentation() {
        return this.instrumentation;
    }

    private class LoaderData {
        private final ServerClassLoaderInfo loaderInfo;
        private final Map<String, byte[]> bytecode = new HashMap<String, byte[]>();
        private final Map<String, Class<?>> refs = new HashMap();

        LoaderData(ServerClassLoaderInfo loaderInfo) {
            this.loaderInfo = loaderInfo;
            InstrumentationHelper.this.server.broadcast(new BroadcastClassloaderMessage(loaderInfo));
        }

        void update(String className, Class<?> ref, byte[] code) {
            this.bytecode.put(className, code);
            if (ref != null) {
                this.refs.put(className, ref);
            }
            InstrumentationHelper.this.server.broadcast(new BroadcastClassMessage(new ClassData(className, this.loaderInfo.getId(), code)));
        }

        Class<?> tryLoad(String name) {
            try {
                Class<?> cls = Class.forName(name.replace('/', '.'), false, this.loaderInfo.getClassLoader());
                this.refs.put(name, cls);
                return cls;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

