/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.data;

import java.util.Objects;
import software.coley.instrument.io.codec.StructureCodec;

public class MemberData {
    public static final StructureCodec<MemberData> CODEC = StructureCodec.compose(input -> new MemberData(input.readUTF(), input.readUTF(), input.readUTF()), (output, value) -> {
        output.writeUTF(value.getOwner());
        output.writeUTF(value.getName());
        output.writeUTF(value.getDesc());
    });
    private final String owner;
    private final String name;
    private final String desc;

    public MemberData(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberData info = (MemberData)o;
        if (!Objects.equals(this.owner, info.owner)) {
            return false;
        }
        if (!Objects.equals(this.name, info.name)) {
            return false;
        }
        return Objects.equals(this.desc, info.desc);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
        return result;
    }
}

