/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.data;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import software.coley.instrument.data.BasicClassLoaderInfo;

public final class ServerClassLoaderInfo
extends BasicClassLoaderInfo {
    public static final ServerClassLoaderInfo BOOTSTRAP;
    public static final ServerClassLoaderInfo SYSTEM;
    public static final ClassLoader SCL;
    private static final WeakReference<ClassLoader> BOOTSTRAP_REF;
    private static final WeakReference<ClassLoader> SCL_REF;
    private static final Method CLASS_LOADER_NAME;
    private final WeakReference<ClassLoader> ref;

    public ServerClassLoaderInfo(ClassLoader loader, int id, String name) {
        super(id, name);
        this.ref = loader == null ? BOOTSTRAP_REF : (loader == SCL ? SCL_REF : new WeakReference<ClassLoader>(loader));
    }

    public static ServerClassLoaderInfo fromLoader(ClassLoader loader) {
        if (loader == null) {
            return BOOTSTRAP;
        }
        if (loader == SCL) {
            return SYSTEM;
        }
        String name = ServerClassLoaderInfo.lookupClassLoaderName(loader);
        int id = loader.hashCode();
        return new ServerClassLoaderInfo(loader, id, name);
    }

    private static String lookupClassLoaderName(ClassLoader loader) {
        Method m = CLASS_LOADER_NAME;
        if (m != null) {
            try {
                String name = (String)m.invoke((Object)loader, new Object[0]);
                if (name != null) {
                    return name;
                }
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Could not get class loader name", ex);
            }
        }
        if (loader == SCL) {
            return "Application ClassLoader";
        }
        if (loader == SCL.getParent()) {
            return "Ext ClassLoader";
        }
        return loader.toString();
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.ref.get();
    }

    public boolean isValid() {
        WeakReference<ClassLoader> ref = this.ref;
        return ref == BOOTSTRAP_REF || ref.get() != null;
    }

    static {
        Method getClassLoaderName;
        BOOTSTRAP = new ServerClassLoaderInfo(null, 0, "Bootstrap ClassLoader");
        SYSTEM = new ServerClassLoaderInfo(ClassLoader.getSystemClassLoader(), 1, "System ClassLoader");
        SCL = ClassLoader.getSystemClassLoader();
        BOOTSTRAP_REF = new WeakReference<Object>(null);
        SCL_REF = new WeakReference<ClassLoader>(ClassLoader.getSystemClassLoader());
        try {
            getClassLoaderName = ClassLoader.class.getMethod("getName", new Class[0]);
            getClassLoaderName.setAccessible(true);
        }
        catch (NoSuchMethodException ignored) {
            getClassLoaderName = null;
        }
        CLASS_LOADER_NAME = getClassLoaderName;
    }
}

