/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.io;

import java.io.DataInput;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import software.coley.instrument.io.ByteBufferCompat;

public final class ByteBufferDataInput
implements DataInput {
    private final ByteBuffer buffer;

    public ByteBufferDataInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void readFully(byte[] b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int skipBytes(int n) {
        ByteBuffer buffer = this.buffer;
        int position = buffer.position();
        int skipped = Math.min(buffer.limit(), position + n);
        ByteBufferCompat.compatPosition(buffer, skipped);
        return buffer.position() - position;
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.get() & 0xFF;
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.getShort() & 0xFF;
    }

    @Override
    public char readChar() {
        return this.buffer.getChar();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        CharBuffer cb;
        ByteBuffer buffer = this.buffer;
        int len = buffer.getInt();
        ByteBuffer slice = buffer.slice().order(buffer.order());
        ((Buffer)slice).limit(len);
        try {
            cb = StandardCharsets.UTF_8.newDecoder().decode(slice);
        }
        catch (CharacterCodingException ex) {
            throw new UncheckedIOException(ex);
        }
        ByteBufferCompat.compatPosition(buffer, buffer.position() + slice.position());
        return cb.toString();
    }
}

