/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.io;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import software.coley.instrument.io.ByteBufferAllocator;
import software.coley.instrument.io.ByteBufferCompat;

public final class ByteBufferSanitizer {
    private static final ByteBuffer EMPTY = ByteBuffer.wrap(new byte[0]);
    private final ByteBufferAllocator allocator;
    private ByteBuffer buffer = EMPTY;

    public ByteBufferSanitizer(ByteBufferAllocator allocator) {
        this.allocator = allocator;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void clear() {
        ByteBufferCompat.compatClear(this.buffer);
    }

    public ByteBuffer consume() {
        ByteBuffer buffer = this.buffer;
        ((Buffer)buffer).flip();
        return buffer;
    }

    public ByteBuffer ensureWriteable(int size) {
        ByteBuffer buffer = this.buffer;
        if (buffer.remaining() < size) {
            int pos = buffer.position();
            size = Integer.highestOneBit(pos + size - 1) << 1;
            ByteBuffer newBuffer = this.allocator.allocate(size);
            ByteBufferCompat.compatPosition(buffer, 0);
            ((Buffer)buffer).limit(pos);
            newBuffer.put(buffer);
            this.buffer = buffer = newBuffer;
        }
        return buffer;
    }
}

