/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.util;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;

public class DescUtil {
    public static final String INT_DESC = DescUtil.getDescriptor(Integer.class);
    public static final String BOOL_DESC = DescUtil.getDescriptor(Boolean.class);
    public static final String BYTE_DESC = DescUtil.getDescriptor(Byte.class);
    public static final String CHAR_DESC = DescUtil.getDescriptor(Character.class);
    public static final String SHORT_DESC = DescUtil.getDescriptor(Short.class);
    public static final String DOUBLE_DESC = DescUtil.getDescriptor(Double.class);
    public static final String FLOAT_DESC = DescUtil.getDescriptor(Float.class);
    public static final String LONG_DESC = DescUtil.getDescriptor(Long.class);
    public static final String STRING_DESC = DescUtil.getDescriptor(String.class);
    public static final String CHAR_SEQUENCE_DESC = DescUtil.getDescriptor(CharSequence.class);
    public static final String STRING_BUILDER_DESC = DescUtil.getDescriptor(StringBuilder.class);
    public static final String STRING_BUFFER_DESC = DescUtil.getDescriptor(StringBuffer.class);
    public static final String FILE_DESC = DescUtil.getDescriptor(File.class);
    public static final String PATH_DESC = DescUtil.getDescriptor(Path.class);

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        DescUtil.appendDescriptor(clazz, sb);
        return sb.toString();
    }

    public static String getDescriptor(Field field) {
        return DescUtil.getDescriptor(field.getType());
    }

    public static String getDescriptor(Method method) {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> parameterType : method.getParameterTypes()) {
            DescUtil.appendDescriptor(parameterType, sb);
        }
        sb.append(")");
        DescUtil.appendDescriptor(method.getReturnType(), sb);
        return sb.toString();
    }

    public static char getPrimitiveName(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 'I';
        }
        if (clazz == Void.TYPE) {
            return 'V';
        }
        if (clazz == Boolean.TYPE) {
            return 'Z';
        }
        if (clazz == Byte.TYPE) {
            return 'B';
        }
        if (clazz == Character.TYPE) {
            return 'C';
        }
        if (clazz == Short.TYPE) {
            return 'S';
        }
        if (clazz == Double.TYPE) {
            return 'D';
        }
        if (clazz == Float.TYPE) {
            return 'F';
        }
        if (clazz == Long.TYPE) {
            return 'J';
        }
        throw new IllegalStateException("Unsupported primitive class: " + clazz);
    }

    public static Class<?> getPrimitiveName(char type) {
        switch (type) {
            case 'I': {
                return Integer.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
        }
        throw new IllegalStateException("Unsupported primitive class desc: " + type);
    }

    public static boolean isPrimitiveName(char type) {
        switch (type) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder sb) {
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            sb.append('[');
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            char descriptor = DescUtil.getPrimitiveName(currentClass);
            sb.append(descriptor);
        } else {
            sb.append('L').append(clazz.getName().replace('.', '/')).append(';');
        }
    }
}

