/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.util;

import java.io.File;
import java.util.Properties;

public class Discovery {
    private static final String PREFIX = "commons-discovery-";
    private static final String SUFFIX = ".jar";

    public static int extractPort(Properties properties) {
        String path = properties.getProperty("java.class.path", null);
        if (path == null || path.isEmpty()) {
            return -1;
        }
        int last = path.lastIndexOf(PREFIX);
        if (last > 0 && path.lastIndexOf(SUFFIX) > last) {
            path = path.substring(last + PREFIX.length(), path.length() - SUFFIX.length());
            try {
                return Integer.parseInt(path);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static String createDiscoveryName(int port) {
        return PREFIX + port + SUFFIX;
    }

    public static void setupDiscovery(int port) {
        String path = System.getProperty("java.class.path", null);
        String discoveryName = Discovery.createDiscoveryName(port);
        if (path == null || path.isEmpty()) {
            path = discoveryName;
        } else if (!path.contains(discoveryName)) {
            path = path + File.pathSeparatorChar + discoveryName;
        }
        System.setProperty("java.class.path", path);
    }

    public static void removeDiscovery(int port) {
        String path = System.getProperty("java.class.path", null);
        String discoveryName = Discovery.createDiscoveryName(port);
        if (path != null && path.contains(discoveryName)) {
            int newLength = path.length() - discoveryName.length();
            if (newLength > 0 && path.charAt(newLength - 1) == File.pathSeparatorChar) {
                --newLength;
            }
            path = path.substring(0, newLength);
            System.setProperty("java.class.path", path);
        }
    }
}

