/*
 * Decompiled with CFR 0.152.
 */
package software.coley.fxaccess;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import software.coley.fxaccess.AccessCheckListener;
import software.coley.fxaccess.Keying;

public class AccessCheck {
    private static final String THREAD_NAME = "JavaFX Application Thread";
    private static final List<AccessCheckListener> listeners = new CopyOnWriteArrayList<AccessCheckListener>();
    private static final Set<String> failedLocations = new TreeSet<String>();

    public static void addAccessCheckListener(@Nonnull AccessCheckListener listener) {
        listeners.add(listener);
    }

    @Nonnull
    public static Set<String> getFailedLocations() {
        return failedLocations;
    }

    public static void check(@Nonnull String callingMethodKey, @Nonnull String calledMethodKey) {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        if (THREAD_NAME.equals(threadName)) {
            return;
        }
        Keying.Key calling = Keying.parseKey(callingMethodKey);
        AccessCheck.notifyListeners(threadName, calling.className(), calling.methodName(), calling.methodDesc(), calling.lineNumber(), callingMethodKey, calledMethodKey);
    }

    private static void notifyListeners(@Nonnull String threadName, @Nonnull String className, @Nonnull String methodName, @Nonnull String methodDesc, int lineNumber, @Nonnull String callingMethodKey, @Nullable String calledMethodSignature) {
        if (failedLocations.add(callingMethodKey)) {
            listeners.forEach(l -> l.onCheckFailed(className, methodName, lineNumber, threadName, calledMethodSignature));
        }
    }
}

