/*
 * Decompiled with CFR 0.152.
 */
package software.coley.fxaccess;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import software.coley.fxaccess.Bootstrapper;
import software.coley.fxaccess.Keying;

public class Agent {
    private static final int ASM_API = 589824;

    public static void premain(String argument, Instrumentation instrumentation) {
        String[] whitelistedPackages;
        String[] stringArray = whitelistedPackages = argument.isBlank() ? new String[]{} : argument.split(";");
        if (whitelistedPackages.length == 0) {
            System.err.print("Missing whitelisted package argument to JFX-TACA. Example format: com.foo;org.bar;fizz.buzz");
            return;
        }
        for (int i = 0; i < whitelistedPackages.length; ++i) {
            whitelistedPackages[i] = whitelistedPackages[i].replace('.', '/');
        }
        instrumentation.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(Module module, ClassLoader loader, String name, Class<?> typeIfLoaded, ProtectionDomain domain, byte[] cls) {
                for (String whitelistedPackage : whitelistedPackages) {
                    if (!name.startsWith(whitelistedPackage)) continue;
                    return 1.doTransform(cls);
                }
                return null;
            }

            private static byte[] doTransform(byte[] cls) {
                ClassReader reader = new ClassReader(cls);
                ClassWriter writer = new ClassWriter(reader, 0);
                AccessInsertionClassVisitor accessChecker = new AccessInsertionClassVisitor(589824, (ClassVisitor)writer);
                reader.accept((ClassVisitor)accessChecker, 0);
                if (accessChecker.isTransformed()) {
                    return writer.toByteArray();
                }
                return null;
            }
        });
    }

    private static class AccessInsertionClassVisitor
    extends ClassVisitor {
        private static final Handle BOOTSTRAP_HANDLE = new Handle(6, Bootstrapper.class.getName().replace('.', '/'), "delegate", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", false);
        private String className;
        private boolean transformed;

        public AccessInsertionClassVisitor(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
        }

        public MethodVisitor visitMethod(int access, final String declaredMethodName, final String declaredMethodDesc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, declaredMethodName, declaredMethodDesc, signature, exceptions);
            if (declaredMethodName.charAt(0) == '<') {
                return mv;
            }
            return new MethodVisitor(this.api, mv){
                private int currentLine;
                {
                    super(arg0, arg1);
                    this.currentLine = -1;
                }

                public void visitLineNumber(int line, Label start) {
                    super.visitLineNumber(line, start);
                    this.currentLine = line;
                }

                public void visitMethodInsn(int opcode, String invocationOwner, String invokedMethodName, String invokedMethodDesc, boolean isInterface) {
                    super.visitMethodInsn(opcode, invocationOwner, invokedMethodName, invokedMethodDesc, isInterface);
                    if (invocationOwner.startsWith("javafx")) {
                        if (invocationOwner.equals("javafx/application/Platform")) {
                            return;
                        }
                        String ourSignature = Keying.key(className, declaredMethodName, declaredMethodDesc, this.currentLine);
                        String fxSignature = Keying.signature(invocationOwner, invokedMethodName, invokedMethodDesc);
                        this.mv.visitInvokeDynamicInsn("acc-check", "()V", BOOTSTRAP_HANDLE, new Object[]{ourSignature, fxSignature});
                        transformed = true;
                    }
                }
            };
        }

        public boolean isTransformed() {
            return this.transformed;
        }
    }
}

