/*
 * Decompiled with CFR 0.152.
 */
package software.coley.fxaccess;

import jakarta.annotation.Nonnull;

public class Keying {
    @Nonnull
    public static String key(@Nonnull String className, @Nonnull String methodName, @Nonnull String methodDesc, int lineNumber) {
        return Keying.key(Keying.signature(className, methodName, methodDesc), lineNumber);
    }

    @Nonnull
    public static String key(@Nonnull String signature, int lineNumber) {
        return signature + "#" + lineNumber;
    }

    @Nonnull
    public static String signature(@Nonnull String className, @Nonnull String methodName, @Nonnull String methodDesc) {
        return className.replace('/', '.') + "#" + methodName + methodDesc;
    }

    @Nonnull
    public static String signatureFromKey(@Nonnull String key) {
        return key.substring(0, key.lastIndexOf(35));
    }

    @Nonnull
    public static Key parseKey(@Nonnull String key) {
        try {
            String[] sections = key.split("#");
            String className = sections[0];
            String methodNameType = sections[1];
            int descIndex = methodNameType.indexOf(40);
            String methodName = methodNameType.substring(0, descIndex);
            String methodDesc = methodName.substring(descIndex);
            int lineNumber = sections.length >= 3 ? Integer.parseInt(sections[2]) : -1;
            return new Key(className, methodName, methodDesc, lineNumber);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Invalid method key: " + key, t);
        }
    }

    public record Key(@Nonnull String className, @Nonnull String methodName, @Nonnull String methodDesc, int lineNumber) {
    }
}

