/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.read.ForwardScanZipReader;
import software.coley.lljzip.format.read.JvmZipReader;
import software.coley.lljzip.format.read.NaiveLocalFileZipReader;
import software.coley.lljzip.format.read.ZipReader;
import software.coley.lljzip.util.BufferData;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.FileMapUtil;

public class ZipIO {
    public static ZipArchive readStandard(ByteData data) throws IOException {
        return ZipIO.read(data, (ZipReader)new ForwardScanZipReader());
    }

    public static ZipArchive readStandard(byte[] data) throws IOException {
        return ZipIO.read(data, (ZipReader)new ForwardScanZipReader());
    }

    public static ZipArchive readStandard(Path data) throws IOException {
        return ZipIO.read(data, (ZipReader)new ForwardScanZipReader());
    }

    public static ZipArchive readNaive(ByteData data) throws IOException {
        return ZipIO.read(data, (ZipReader)new NaiveLocalFileZipReader());
    }

    public static ZipArchive readNaive(byte[] data) throws IOException {
        return ZipIO.read(data, (ZipReader)new NaiveLocalFileZipReader());
    }

    public static ZipArchive readNaive(Path data) throws IOException {
        return ZipIO.read(data, (ZipReader)new NaiveLocalFileZipReader());
    }

    public static ZipArchive readJvm(ByteData data) throws IOException {
        return ZipIO.read(data, (ZipReader)new JvmZipReader());
    }

    public static ZipArchive readJvm(byte[] data) throws IOException {
        return ZipIO.read(data, (ZipReader)new JvmZipReader());
    }

    public static ZipArchive readJvm(Path path) throws IOException {
        return ZipIO.read(path, (ZipReader)new JvmZipReader());
    }

    public static ZipArchive read(byte[] data, ZipReader strategy) throws IOException {
        if (data == null) {
            throw new IOException("Data is null!");
        }
        return ZipIO.read(BufferData.wrap(data), strategy);
    }

    public static ZipArchive read(Path path, ZipReader strategy) throws IOException {
        if (path == null) {
            throw new IOException("Data is null!");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new FileNotFoundException(path.toString());
        }
        return ZipIO.read(FileMapUtil.map(path), strategy);
    }

    public static ZipArchive read(ByteData data, ZipReader strategy) throws IOException {
        if (data == null) {
            throw new IOException("Data is null!");
        }
        if (data.length() < 22L) {
            throw new IOException("Not enough bytes to read Central-Directory-File-Header, minimum=22");
        }
        ZipArchive zip = new ZipArchive(data);
        strategy.read(zip, data);
        return zip;
    }
}

