/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.compression;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import software.coley.lljzip.format.compression.Decompressor;
import software.coley.lljzip.format.compression.DeflateEntry;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.FastWrapOutputStream;
import software.coley.lljzip.util.InflaterHackery;

public class UnsafeDeflateDecompressor
implements Decompressor {
    public static final UnsafeDeflateDecompressor INSTANCE = new UnsafeDeflateDecompressor();
    private static final int DEFLATE_CACHE_LIMIT = 64;
    private static final Deque<DeflateEntry> DEFLATE_ENTRIES;

    private UnsafeDeflateDecompressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteData decompress(LocalFileHeader header, ByteData data) throws IOException {
        DeflateEntry entry;
        Deque<DeflateEntry> inflaters;
        if (header.getCompressionMethod() != 8) {
            throw new IOException("LocalFileHeader contents not using 'Deflated'!");
        }
        FastWrapOutputStream out = new FastWrapOutputStream();
        Deque<DeflateEntry> deque = inflaters = DEFLATE_ENTRIES;
        synchronized (deque) {
            entry = inflaters.poll();
        }
        if (entry == null) {
            entry = new DeflateEntry();
        } else {
            entry.reset();
        }
        try {
            byte[] byArray = entry.decompress;
            byte[] buffer = entry.buffer;
            Inflater inflater = entry.inflater;
            long position = 0L;
            long length = data.length();
            int remaining = 0;
            boolean needsInput = true;
            while (true) {
                int state;
                if (needsInput) {
                    remaining = (int)Math.min((long)buffer.length, length);
                    if (remaining != 0) {
                        data.get(position, buffer, 0, remaining);
                        length -= (long)remaining;
                        position += (long)remaining;
                        inflater.setInput(buffer, 0, remaining);
                    }
                    entry.offset = 0;
                }
                if (remaining <= 0) break;
                int written = InflaterHackery.inflate(entry, buffer, remaining, byArray);
                if (written != 0) {
                    out.write(byArray, 0, written);
                }
                if (((state = entry.state) & 2) == 2) {
                    if (!InflaterHackery.NEW_INFLATE) {
                        entry.inflater.reset();
                    }
                    break;
                }
                needsInput = state == 1;
            }
        }
        catch (DataFormatException dataFormatException) {
            String s = dataFormatException.getMessage();
            throw (ZipException)new ZipException(s != null ? null : "Invalid ZLIB data format").initCause(dataFormatException);
        }
        finally {
            block26: {
                if (inflaters.size() < 64) {
                    Deque<DeflateEntry> deque2 = inflaters;
                    synchronized (deque2) {
                        if (inflaters.size() < 64) {
                            inflaters.addFirst(entry);
                            break block26;
                        }
                    }
                }
                entry.inflater.end();
            }
        }
        return out.wrap();
    }

    static {
        Deque<DeflateEntry> entries = DEFLATE_ENTRIES = new ArrayDeque<DeflateEntry>();
        for (int i = 0; i < 64; ++i) {
            entries.push(new DeflateEntry());
        }
    }
}

