/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.compression;

import java.io.IOException;
import software.coley.lljzip.format.compression.UnsafeDeflateDecompressor;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.ByteData;

public interface ZipCompressions {
    public static final int STORED = 0;
    public static final int SHRUNK = 1;
    public static final int REDUCED_F1 = 2;
    public static final int REDUCED_F2 = 3;
    public static final int REDUCED_F3 = 4;
    public static final int REDUCED_F4 = 5;
    public static final int IMPLODED = 6;
    public static final int RESERVED_TOKENIZING = 7;
    public static final int DEFLATED = 8;
    public static final int DEFLATED_64 = 9;
    public static final int PKWARE_IMPLODING = 10;
    public static final int PKWARE_RESERVED_11 = 11;
    public static final int BZIP2 = 12;
    public static final int PKWARE_RESERVED_13 = 13;
    public static final int LZMA = 14;
    public static final int PKWARE_RESERVED_15 = 15;
    public static final int CMPSC = 16;
    public static final int PKWARE_RESERVED_17 = 17;
    public static final int IBM_TERSE = 18;
    public static final int IBM_LZ77 = 19;
    public static final int DEPRECATED_ZSTD = 20;
    public static final int ZSTANDARD = 93;
    public static final int MP3 = 94;
    public static final int XZ = 95;
    public static final int JPEG = 96;
    public static final int WAVPACK = 97;
    public static final int PPMD = 98;
    public static final int AE_x = 99;

    public static String getName(int method) {
        switch (method) {
            case 0: {
                return "STORED";
            }
            case 1: {
                return "SHRUNK";
            }
            case 2: {
                return "REDUCED_F1";
            }
            case 3: {
                return "REDUCED_F2";
            }
            case 4: {
                return "REDUCED_F3";
            }
            case 5: {
                return "REDUCED_F4";
            }
            case 6: {
                return "IMPLODED";
            }
            case 7: {
                return "RESERVED_TOKENIZING";
            }
            case 8: {
                return "DEFLATED";
            }
            case 9: {
                return "DEFLATED_64";
            }
            case 10: {
                return "PKWARE_IMPLODING";
            }
            case 11: {
                return "PKWARE_RESERVED_11";
            }
            case 12: {
                return "BZIP2";
            }
            case 13: {
                return "PKWARE_RESERVED_13";
            }
            case 14: {
                return "LZMA";
            }
            case 15: {
                return "PKWARE_RESERVED_15";
            }
            case 16: {
                return "CMPSC";
            }
            case 17: {
                return "PKWARE_RESERVED_17";
            }
            case 18: {
                return "IBM_TERSE";
            }
            case 19: {
                return "IBM_LZ77";
            }
            case 20: {
                return "DEPRECATED_ZSTD";
            }
            case 93: {
                return "ZSTANDARD";
            }
            case 94: {
                return "MP3";
            }
            case 95: {
                return "XZ";
            }
            case 96: {
                return "JPEG";
            }
            case 97: {
                return "WAVPACK";
            }
            case 98: {
                return "PPMD";
            }
            case 99: {
                return "AE_x";
            }
        }
        return "Unknown[" + method + "]";
    }

    public static ByteData decompress(LocalFileHeader header) throws IOException {
        int method = header.getCompressionMethod();
        switch (method) {
            case 0: {
                return header.getFileData();
            }
            case 8: {
                return header.decompress(UnsafeDeflateDecompressor.INSTANCE);
            }
        }
        String methodName = ZipCompressions.getName(method);
        throw new IOException("Unsupported compression method: " + methodName);
    }
}

