/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.lljzip.format.model.ZipPart;
import software.coley.lljzip.format.model.ZipRead;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;
import software.coley.lljzip.util.lazy.LazyByteData;
import software.coley.lljzip.util.lazy.LazyInt;
import software.coley.lljzip.util.lazy.LazyLong;

public abstract class AbstractZipFileHeader
implements ZipPart,
ZipRead {
    protected LazyInt versionNeededToExtract;
    protected LazyInt generalPurposeBitFlag;
    protected LazyInt compressionMethod;
    protected LazyInt lastModFileTime;
    protected LazyInt lastModFileDate;
    protected LazyInt crc32;
    protected LazyLong compressedSize;
    protected LazyLong uncompressedSize;
    protected LazyInt fileNameLength;
    protected LazyInt extraFieldLength;
    protected LazyByteData fileName;
    protected LazyByteData extraField;
    protected transient long offset = -1L;
    protected transient ByteData data;
    private transient String fileNameCache;
    private transient String extraFieldCache;

    @Nullable
    public ByteData getBackingData() {
        return this.data;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public void read(@Nonnull ByteData data, long offset) {
        this.data = data;
        this.offset = offset;
    }

    public int getVersionNeededToExtract() {
        return this.versionNeededToExtract.get();
    }

    public void setVersionNeededToExtract(int versionNeededToExtract) {
        this.versionNeededToExtract.set(versionNeededToExtract);
    }

    public int getGeneralPurposeBitFlag() {
        return this.generalPurposeBitFlag.get();
    }

    public void setGeneralPurposeBitFlag(int generalPurposeBitFlag) {
        this.generalPurposeBitFlag.set(generalPurposeBitFlag);
    }

    public int getCompressionMethod() {
        return this.compressionMethod.get();
    }

    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod.set(compressionMethod);
    }

    public int getLastModFileTime() {
        return this.lastModFileTime.get();
    }

    public void setLastModFileTime(int lastModFileTime) {
        this.lastModFileTime.set(lastModFileTime);
    }

    public int getLastModFileDate() {
        return this.lastModFileDate.get();
    }

    public void setLastModFileDate(int lastModFileDate) {
        this.lastModFileDate.set(lastModFileDate);
    }

    public int getCrc32() {
        return this.crc32.get();
    }

    public void setCrc32(int crc32) {
        this.crc32.set(crc32);
    }

    public long getCompressedSize() {
        return this.compressedSize.get();
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize.set(compressedSize & 0xFFFFFFFFL);
    }

    public long getUncompressedSize() {
        return this.uncompressedSize.get();
    }

    public void setUncompressedSize(long uncompressedSize) {
        this.uncompressedSize.set(uncompressedSize & 0xFFFFFFFFL);
    }

    public int getFileNameLength() {
        return this.fileNameLength.get();
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength.set(fileNameLength & 0xFFFF);
    }

    public int getExtraFieldLength() {
        return this.extraFieldLength.get();
    }

    public void setExtraFieldLength(int extraFieldLength) {
        this.extraFieldLength.set(extraFieldLength & 0xFFFF);
    }

    public ByteData getFileName() {
        return this.fileName.get();
    }

    public void setFileName(ByteData fileName) {
        this.fileName.set(fileName);
        this.fileNameCache = null;
    }

    public String getFileNameAsString() {
        String fileNameCache = this.fileNameCache;
        if (fileNameCache == null) {
            this.fileNameCache = ByteDataUtil.toString(this.fileName.get());
            return this.fileNameCache;
        }
        return fileNameCache;
    }

    public ByteData getExtraField() {
        return this.extraField.get();
    }

    public void setExtraField(ByteData extraField) {
        this.extraField.set(extraField);
    }

    public String getExtraFieldAsString() {
        String fileCommentCache = this.extraFieldCache;
        if (fileCommentCache == null) {
            this.extraFieldCache = ByteDataUtil.toString(this.extraField.get());
            return this.extraFieldCache;
        }
        return fileCommentCache;
    }
}

