/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.AbstractZipFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.PartType;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;
import software.coley.lljzip.util.lazy.LazyByteData;
import software.coley.lljzip.util.lazy.LazyInt;
import software.coley.lljzip.util.lazy.LazyLong;

public class CentralDirectoryFileHeader
extends AbstractZipFileHeader {
    protected static final long MIN_FIXED_SIZE = 46L;
    private transient LocalFileHeader linkedFileHeader;
    private LazyInt versionMadeBy;
    private LazyInt fileCommentLength;
    private LazyByteData fileComment;
    private LazyInt diskNumberStart;
    private LazyInt internalFileAttributes;
    private LazyInt externalFileAttributes;
    private LazyLong relativeOffsetOfLocalHeader;
    private transient String fileCommentCache;

    @Nonnull
    public CentralDirectoryFileHeader copy() {
        CentralDirectoryFileHeader copy = new CentralDirectoryFileHeader();
        copy.data = this.data;
        copy.offset = this.offset;
        copy.linkedFileHeader = this.linkedFileHeader;
        copy.versionMadeBy = this.versionMadeBy.copy();
        copy.versionNeededToExtract = this.versionNeededToExtract.copy();
        copy.generalPurposeBitFlag = this.generalPurposeBitFlag.copy();
        copy.compressionMethod = this.compressionMethod.copy();
        copy.lastModFileTime = this.lastModFileTime.copy();
        copy.lastModFileDate = this.lastModFileDate.copy();
        copy.crc32 = this.crc32.copy();
        copy.compressedSize = this.compressedSize.copy();
        copy.uncompressedSize = this.uncompressedSize.copy();
        copy.fileNameLength = this.fileNameLength.copy();
        copy.extraFieldLength = this.extraFieldLength.copy();
        copy.fileCommentLength = this.fileCommentLength.copy();
        copy.diskNumberStart = this.diskNumberStart.copy();
        copy.internalFileAttributes = this.internalFileAttributes.copy();
        copy.externalFileAttributes = this.externalFileAttributes.copy();
        copy.relativeOffsetOfLocalHeader = this.relativeOffsetOfLocalHeader.copy();
        copy.fileName = this.fileName.copy();
        copy.extraField = this.extraField.copy();
        copy.fileComment = this.fileComment.copy();
        return copy;
    }

    @Override
    public void read(@Nonnull ByteData data, long offset) {
        super.read(data, offset);
        this.versionMadeBy = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 4).withId("versionMadeBy");
        this.versionNeededToExtract = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 6).withId("versionNeededToExtract");
        this.generalPurposeBitFlag = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 8).withId("generalPurposeBitFlag");
        this.compressionMethod = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 10).withId("compressionMethod");
        this.lastModFileTime = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 12).withId("lastModFileTime");
        this.lastModFileDate = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 14).withId("lastModFileDate");
        this.crc32 = (LazyInt)ByteDataUtil.readLazyQuad(data, offset, 16).withId("crc32");
        this.compressedSize = (LazyLong)ByteDataUtil.readLazyMaskedLongQuad(data, offset, 20).withId("compressedSize");
        this.uncompressedSize = (LazyLong)ByteDataUtil.readLazyMaskedLongQuad(data, offset, 24).withId("uncompressedSize");
        this.fileNameLength = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 28).withId("fileNameLength");
        this.extraFieldLength = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 30).withId("extraFieldLength");
        this.fileCommentLength = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 32).withId("fileCommentLength");
        this.diskNumberStart = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 34).withId("diskNumberStart");
        this.internalFileAttributes = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 36).withId("internalFileAttributes");
        this.externalFileAttributes = (LazyInt)ByteDataUtil.readLazyQuad(data, offset, 38).withId("externalFileAttributes");
        this.relativeOffsetOfLocalHeader = (LazyLong)ByteDataUtil.readLazyMaskedLongQuad(data, offset, 42).withId("relativeOffsetOfLocalHeader");
        this.fileName = (LazyByteData)ByteDataUtil.readLazySlice(data, offset, new LazyInt(() -> 46), this.fileNameLength).withId("fileName");
        this.extraField = (LazyByteData)ByteDataUtil.readLazySlice(data, offset, this.fileNameLength.add(46), this.extraFieldLength).withId("extraField");
        this.fileComment = (LazyByteData)ByteDataUtil.readLazySlice(data, offset, this.fileNameLength.add(46).add(this.extraFieldLength), this.fileCommentLength).withId("fileComment");
    }

    @Override
    public long length() {
        return 46L + (long)this.fileNameLength.get() + (long)this.extraFieldLength.get() + (long)this.fileCommentLength.get();
    }

    @Override
    @Nonnull
    public PartType type() {
        return PartType.CENTRAL_DIRECTORY_FILE_HEADER;
    }

    public LocalFileHeader getLinkedFileHeader() {
        return this.linkedFileHeader;
    }

    public void link(LocalFileHeader header) {
        this.linkedFileHeader = header;
    }

    public int getVersionMadeBy() {
        return this.versionMadeBy.get();
    }

    public void setVersionMadeBy(int versionMadeBy) {
        this.versionMadeBy.set(versionMadeBy);
    }

    public int getDiskNumberStart() {
        return this.diskNumberStart.get();
    }

    public void setDiskNumberStart(int diskNumberStart) {
        this.diskNumberStart.set(diskNumberStart);
    }

    public int getInternalFileAttributes() {
        return this.internalFileAttributes.get();
    }

    public void setInternalFileAttributes(int internalFileAttributes) {
        this.internalFileAttributes.set(internalFileAttributes);
    }

    public int getExternalFileAttributes() {
        return this.externalFileAttributes.get();
    }

    public void setExternalFileAttributes(int externalFileAttributes) {
        this.externalFileAttributes.set(externalFileAttributes);
    }

    public long getRelativeOffsetOfLocalHeader() {
        return this.relativeOffsetOfLocalHeader.get();
    }

    public void setRelativeOffsetOfLocalHeader(long relativeOffsetOfLocalHeader) {
        this.relativeOffsetOfLocalHeader.set(relativeOffsetOfLocalHeader & 0xFFFFFFFFL);
    }

    public int getFileCommentLength() {
        return this.fileCommentLength.get();
    }

    public void setFileCommentLength(int fileCommentLength) {
        this.fileCommentLength.set(fileCommentLength & 0xFFFF);
    }

    public ByteData getFileComment() {
        return this.fileComment.get();
    }

    public void setFileComment(ByteData fileComment) {
        this.fileComment.set(fileComment);
    }

    public String getFileCommentAsString() {
        String fileCommentCache = this.fileCommentCache;
        if (fileCommentCache == null) {
            this.fileCommentCache = ByteDataUtil.toString(this.fileComment.get());
            return this.fileCommentCache;
        }
        return fileCommentCache;
    }

    public String toString() {
        return "CentralDirectoryFileHeader{  versionMadeBy=" + this.versionMadeBy + ", versionNeededToExtract=" + this.versionNeededToExtract + ", generalPurposeBitFlag=" + this.generalPurposeBitFlag + ", compressionMethod=" + this.compressionMethod + ", lastModFileTime=" + this.lastModFileTime + ", lastModFileDate=" + this.lastModFileDate + ", crc32=" + this.crc32 + ", compressedSize=" + this.compressedSize + ", uncompressedSize=" + this.uncompressedSize + ", fileNameLength=" + this.fileNameLength + ", extraFieldLength=" + this.extraFieldLength + ", fileCommentLength=" + this.fileCommentLength + ", diskNumberStart=" + this.diskNumberStart + ", internalFileAttributes=" + this.internalFileAttributes + ", externalFileAttributes=" + this.externalFileAttributes + ", relativeOffsetOfLocalHeader=" + this.relativeOffsetOfLocalHeader + ", fileName='" + this.getFileNameAsString() + '\'' + ", extraField='" + this.getExtraFieldAsString() + '\'' + ", fileComment='" + this.getFileCommentAsString() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CentralDirectoryFileHeader that = (CentralDirectoryFileHeader)o;
        if (!Objects.equals(this.linkedFileHeader, that.linkedFileHeader)) {
            return false;
        }
        if (!Objects.equals(this.versionMadeBy, that.versionMadeBy)) {
            return false;
        }
        if (!Objects.equals(this.versionNeededToExtract, that.versionNeededToExtract)) {
            return false;
        }
        if (!Objects.equals(this.generalPurposeBitFlag, that.generalPurposeBitFlag)) {
            return false;
        }
        if (!Objects.equals(this.compressionMethod, that.compressionMethod)) {
            return false;
        }
        if (!Objects.equals(this.lastModFileTime, that.lastModFileTime)) {
            return false;
        }
        if (!Objects.equals(this.lastModFileDate, that.lastModFileDate)) {
            return false;
        }
        if (!Objects.equals(this.crc32, that.crc32)) {
            return false;
        }
        if (!Objects.equals(this.compressedSize, that.compressedSize)) {
            return false;
        }
        if (!Objects.equals(this.uncompressedSize, that.uncompressedSize)) {
            return false;
        }
        if (!Objects.equals(this.fileNameLength, that.fileNameLength)) {
            return false;
        }
        if (!Objects.equals(this.extraFieldLength, that.extraFieldLength)) {
            return false;
        }
        if (!Objects.equals(this.fileCommentLength, that.fileCommentLength)) {
            return false;
        }
        if (!Objects.equals(this.diskNumberStart, that.diskNumberStart)) {
            return false;
        }
        if (!Objects.equals(this.internalFileAttributes, that.internalFileAttributes)) {
            return false;
        }
        if (!Objects.equals(this.externalFileAttributes, that.externalFileAttributes)) {
            return false;
        }
        if (!Objects.equals(this.relativeOffsetOfLocalHeader, that.relativeOffsetOfLocalHeader)) {
            return false;
        }
        if (!Objects.equals(this.fileName, that.fileName)) {
            return false;
        }
        if (!Objects.equals(this.extraField, that.extraField)) {
            return false;
        }
        return Objects.equals(this.fileComment, that.fileComment);
    }

    public int hashCode() {
        int result = this.linkedFileHeader != null ? this.linkedFileHeader.hashCode() : 0;
        result = 31 * result + (this.versionMadeBy != null ? this.versionMadeBy.hashCode() : 0);
        result = 31 * result + (this.versionNeededToExtract != null ? this.versionNeededToExtract.hashCode() : 0);
        result = 31 * result + (this.generalPurposeBitFlag != null ? this.generalPurposeBitFlag.hashCode() : 0);
        result = 31 * result + (this.compressionMethod != null ? this.compressionMethod.hashCode() : 0);
        result = 31 * result + (this.lastModFileTime != null ? this.lastModFileTime.hashCode() : 0);
        result = 31 * result + (this.lastModFileDate != null ? this.lastModFileDate.hashCode() : 0);
        result = 31 * result + (this.crc32 != null ? this.crc32.hashCode() : 0);
        result = 31 * result + (this.compressedSize != null ? this.compressedSize.hashCode() : 0);
        result = 31 * result + (this.uncompressedSize != null ? this.uncompressedSize.hashCode() : 0);
        result = 31 * result + (this.fileNameLength != null ? this.fileNameLength.hashCode() : 0);
        result = 31 * result + (this.extraFieldLength != null ? this.extraFieldLength.hashCode() : 0);
        result = 31 * result + (this.fileCommentLength != null ? this.fileCommentLength.hashCode() : 0);
        result = 31 * result + (this.diskNumberStart != null ? this.diskNumberStart.hashCode() : 0);
        result = 31 * result + (this.internalFileAttributes != null ? this.internalFileAttributes.hashCode() : 0);
        result = 31 * result + (this.externalFileAttributes != null ? this.externalFileAttributes.hashCode() : 0);
        result = 31 * result + (this.relativeOffsetOfLocalHeader != null ? this.relativeOffsetOfLocalHeader.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.extraField != null ? this.extraField.hashCode() : 0);
        result = 31 * result + (this.fileComment != null ? this.fileComment.hashCode() : 0);
        return result;
    }
}

